/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgParser;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;

public class MovAvgBuilder
extends PipelineAggregatorBuilder<MovAvgBuilder> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;
    private MovAvgModelBuilder modelBuilder;
    private Integer window;
    private Integer predict;
    private Boolean minimize;
    private Map<String, Object> settings;

    public MovAvgBuilder(String name) {
        super(name, MovAvgPipelineAggregator.TYPE.name());
    }

    public MovAvgBuilder format(String format) {
        this.format = format;
        return this;
    }

    public MovAvgBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return this;
    }

    public MovAvgBuilder modelBuilder(MovAvgModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public MovAvgBuilder window(int window) {
        this.window = window;
        return this;
    }

    public MovAvgBuilder predict(int numPredictions) {
        this.predict = numPredictions;
        return this;
    }

    public MovAvgBuilder minimize(boolean minimize) {
        this.minimize = minimize;
        return this;
    }

    public MovAvgBuilder settings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(MovAvgParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(MovAvgParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.toXContent(builder, params);
        }
        if (this.window != null) {
            builder.field(MovAvgParser.WINDOW.getPreferredName(), this.window);
        }
        if (this.predict != null) {
            builder.field(MovAvgParser.PREDICT.getPreferredName(), this.predict);
        }
        if (this.minimize != null) {
            builder.field(MovAvgParser.MINIMIZE.getPreferredName(), (Object)this.minimize);
        }
        if (this.settings != null) {
            builder.field(MovAvgParser.SETTINGS.getPreferredName(), this.settings);
        }
        return builder;
    }
}

