/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.controller;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResultProvider;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.InternalProfileShardResults;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;

public class SearchPhaseController
extends AbstractComponent {
    public static final Comparator<AtomicArray.Entry<? extends QuerySearchResultProvider>> QUERY_RESULT_ORDERING = new Comparator<AtomicArray.Entry<? extends QuerySearchResultProvider>>(){

        @Override
        public int compare(AtomicArray.Entry<? extends QuerySearchResultProvider> o1, AtomicArray.Entry<? extends QuerySearchResultProvider> o2) {
            int i = ((QuerySearchResultProvider)o1.value).shardTarget().index().compareTo(((QuerySearchResultProvider)o2.value).shardTarget().index());
            if (i == 0) {
                i = ((QuerySearchResultProvider)o1.value).shardTarget().shardId() - ((QuerySearchResultProvider)o2.value).shardTarget().shardId();
            }
            return i;
        }
    };
    public static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    public static final String SEARCH_CONTROLLER_OPTIMIZE_SINGLE_SHARD_KEY = "search.controller.optimize_single_shard";
    private final BigArrays bigArrays;
    private final boolean optimizeSingleShard;
    private ScriptService scriptService;

    @Inject
    public SearchPhaseController(Settings settings, BigArrays bigArrays, ScriptService scriptService) {
        super(settings);
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.optimizeSingleShard = settings.getAsBoolean(SEARCH_CONTROLLER_OPTIMIZE_SINGLE_SHARD_KEY, (Boolean)true);
    }

    public boolean optimizeSingleShard() {
        return this.optimizeSingleShard;
    }

    public AggregatedDfs aggregateDfs(AtomicArray<DfsSearchResult> results) {
        ObjectObjectHashMap termStatistics = HppcMaps.newNoNullKeysMap();
        ObjectObjectHashMap fieldStatistics = HppcMaps.newNoNullKeysMap();
        long aggMaxDoc = 0L;
        for (AtomicArray.Entry<DfsSearchResult> lEntry : results.asList()) {
            Term[] terms = ((DfsSearchResult)lEntry.value).terms();
            TermStatistics[] stats = ((DfsSearchResult)lEntry.value).termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                TermStatistics existing = (TermStatistics)termStatistics.get((Object)terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals((Object)existing.term()));
                    termStatistics.put((Object)terms[i], (Object)new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), SearchPhaseController.optionalSum(existing.totalTermFreq(), stats[i].totalTermFreq())));
                    continue;
                }
                termStatistics.put((Object)terms[i], (Object)stats[i]);
            }
            assert (!((DfsSearchResult)lEntry.value).fieldStatistics().containsKey(null));
            Object[] keys = ((DfsSearchResult)lEntry.value).fieldStatistics().keys;
            Object[] values = ((DfsSearchResult)lEntry.value).fieldStatistics().values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                String key = (String)keys[i];
                CollectionStatistics value = (CollectionStatistics)values[i];
                assert (key != null);
                CollectionStatistics existing = (CollectionStatistics)fieldStatistics.get((Object)key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), SearchPhaseController.optionalSum(existing.docCount(), value.docCount()), SearchPhaseController.optionalSum(existing.sumTotalTermFreq(), value.sumTotalTermFreq()), SearchPhaseController.optionalSum(existing.sumDocFreq(), value.sumDocFreq()));
                    fieldStatistics.put((Object)key, (Object)merged);
                    continue;
                }
                fieldStatistics.put((Object)key, (Object)value);
            }
            aggMaxDoc += (long)((DfsSearchResult)lEntry.value).maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    private static long optionalSum(long left, long right) {
        return Math.min(left, right) == -1L ? -1L : left + right;
    }

    public ScoreDoc[] sortDocs(boolean ignoreFrom, AtomicArray<? extends QuerySearchResultProvider> resultsArr) throws IOException {
        TopDocs mergedTopDocs;
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> results = resultsArr.asList();
        if (results.isEmpty()) {
            return EMPTY_DOCS;
        }
        if (this.optimizeSingleShard) {
            boolean canOptimize = false;
            QuerySearchResult result = null;
            int shardIndex = -1;
            if (results.size() == 1) {
                canOptimize = true;
                result = ((QuerySearchResultProvider)results.get((int)0).value).queryResult();
                shardIndex = results.get((int)0).index;
            } else {
                for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : results) {
                    if (((QuerySearchResultProvider)entry.value).queryResult().topDocs().scoreDocs.length <= 0) continue;
                    if (result != null) {
                        canOptimize = false;
                        break;
                    }
                    canOptimize = true;
                    result = ((QuerySearchResultProvider)entry.value).queryResult();
                    shardIndex = entry.index;
                }
            }
            if (canOptimize) {
                ScoreDoc[] scoreDocs;
                int offset = result.from();
                if (ignoreFrom) {
                    offset = 0;
                }
                if ((scoreDocs = result.topDocs().scoreDocs).length == 0 || scoreDocs.length < offset) {
                    return EMPTY_DOCS;
                }
                int resultDocsSize = result.size();
                if (scoreDocs.length - offset < resultDocsSize) {
                    resultDocsSize = scoreDocs.length - offset;
                }
                ScoreDoc[] docs = new ScoreDoc[resultDocsSize];
                for (int i = 0; i < resultDocsSize; ++i) {
                    ScoreDoc scoreDoc = scoreDocs[offset + i];
                    scoreDoc.shardIndex = shardIndex;
                    docs[i] = scoreDoc;
                }
                return docs;
            }
        }
        AtomicArray.Entry[] sortedResults = results.toArray(new AtomicArray.Entry[results.size()]);
        Arrays.sort(sortedResults, QUERY_RESULT_ORDERING);
        QuerySearchResultProvider firstResult = (QuerySearchResultProvider)sortedResults[0].value;
        int topN = firstResult.queryResult().size();
        if (firstResult.includeFetch()) {
            topN *= sortedResults.length;
        }
        int from = firstResult.queryResult().from();
        if (ignoreFrom) {
            from = 0;
        }
        if (firstResult.queryResult().topDocs() instanceof TopFieldDocs) {
            TopFieldDocs firstTopDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            Sort sort = new Sort(firstTopDocs.fields);
            TopFieldDocs[] shardTopDocs = new TopFieldDocs[resultsArr.length()];
            for (AtomicArray.Entry sortedResult : sortedResults) {
                TopDocs topDocs = ((QuerySearchResultProvider)sortedResult.value).queryResult().topDocs();
                shardTopDocs[sortedResult.index] = (TopFieldDocs)topDocs;
            }
            for (int i = 0; i < shardTopDocs.length; ++i) {
                if (shardTopDocs[i] != null) continue;
                shardTopDocs[i] = new TopFieldDocs(0, (ScoreDoc[])new FieldDoc[0], sort.getSort(), Float.NaN);
            }
            mergedTopDocs = TopDocs.merge((Sort)sort, (int)from, (int)topN, (TopFieldDocs[])shardTopDocs);
        } else {
            TopDocs[] shardTopDocs = new TopDocs[resultsArr.length()];
            for (AtomicArray.Entry sortedResult : sortedResults) {
                TopDocs topDocs;
                shardTopDocs[sortedResult.index] = topDocs = ((QuerySearchResultProvider)sortedResult.value).queryResult().topDocs();
            }
            for (int i = 0; i < shardTopDocs.length; ++i) {
                if (shardTopDocs[i] != null) continue;
                shardTopDocs[i] = Lucene.EMPTY_TOP_DOCS;
            }
            mergedTopDocs = TopDocs.merge((int)from, (int)topN, (TopDocs[])shardTopDocs);
        }
        return mergedTopDocs.scoreDocs;
    }

    public ScoreDoc[] getLastEmittedDocPerShard(SearchRequest request, ScoreDoc[] sortedShardList, int numShards) {
        if (request.scroll() != null) {
            return this.getLastEmittedDocPerShard(sortedShardList, numShards);
        }
        return null;
    }

    public ScoreDoc[] getLastEmittedDocPerShard(ScoreDoc[] sortedShardList, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        ScoreDoc[] scoreDocArray = sortedShardList;
        int n = scoreDocArray.length;
        for (int i = 0; i < n; ++i) {
            ScoreDoc scoreDoc;
            lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = scoreDocArray[i];
        }
        return lastEmittedDocPerShard;
    }

    public void fillDocIdsToLoad(AtomicArray<IntArrayList> docsIdsToLoad, ScoreDoc[] shardDocs) {
        for (ScoreDoc shardDoc : shardDocs) {
            IntArrayList list = docsIdsToLoad.get(shardDoc.shardIndex);
            if (list == null) {
                list = new IntArrayList();
                docsIdsToLoad.set(shardDoc.shardIndex, list);
            }
            list.add(shardDoc.doc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public InternalSearchResponse merge(ScoreDoc[] sortedDocs, AtomicArray<? extends QuerySearchResultProvider> queryResultsArr, AtomicArray<? extends FetchSearchResultProvider> fetchResultsArr, HasContextAndHeaders headersContext) {
        void var16_24;
        List<SiblingPipelineAggregator> pipelineAggregators;
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> queryResults = queryResultsArr.asList();
        List<AtomicArray.Entry<? extends FetchSearchResultProvider>> fetchResults = fetchResultsArr.asList();
        if (queryResults.isEmpty()) {
            return InternalSearchResponse.empty();
        }
        QuerySearchResult firstResult = ((QuerySearchResultProvider)queryResults.get((int)0).value).queryResult();
        boolean sorted = false;
        int sortScoreIndex = -1;
        if (firstResult.topDocs() instanceof TopFieldDocs) {
            sorted = true;
            TopFieldDocs fieldDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            for (int i = 0; i < fieldDocs.fields.length; ++i) {
                if (fieldDocs.fields[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        long totalHits = 0L;
        float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
            QuerySearchResult result = ((QuerySearchResultProvider)entry.value).queryResult();
            if (result.searchTimedOut()) {
                timedOut = true;
            }
            if (result.terminatedEarly() != null) {
                if (terminatedEarly == null) {
                    terminatedEarly = result.terminatedEarly();
                } else if (result.terminatedEarly().booleanValue()) {
                    terminatedEarly = true;
                }
            }
            totalHits += (long)result.topDocs().totalHits;
            if (Float.isNaN(result.topDocs().getMaxScore())) continue;
            maxScore = Math.max(maxScore, result.topDocs().getMaxScore());
        }
        if (Float.isInfinite(maxScore)) {
            maxScore = Float.NaN;
        }
        for (AtomicArray.Entry<SearchPhaseResult> entry : fetchResults) {
            ((FetchSearchResultProvider)entry.value).fetchResult().initCounter();
        }
        ArrayList<InternalSearchHit> hits = new ArrayList<InternalSearchHit>();
        if (!fetchResults.isEmpty()) {
            for (ScoreDoc shardDoc : sortedDocs) {
                FetchSearchResult fetchSearchResult;
                int index;
                FetchSearchResultProvider fetchSearchResultProvider = fetchResultsArr.get(shardDoc.shardIndex);
                if (fetchSearchResultProvider == null || (index = (fetchSearchResult = fetchSearchResultProvider.fetchResult()).counterGetAndIncrement()) >= fetchSearchResult.hits().internalHits().length) continue;
                InternalSearchHit searchHit = fetchSearchResult.hits().internalHits()[index];
                searchHit.score(shardDoc.score);
                searchHit.shard(fetchSearchResult.shardTarget());
                if (sorted) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                }
                hits.add(searchHit);
            }
        }
        Object var16_22 = null;
        if (!queryResults.isEmpty()) {
            HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = new HashMap<String, List<Suggest.Suggestion>>();
            boolean hasSuggestions = false;
            for (AtomicArray.Entry entry : queryResults) {
                Suggest suggest = ((QuerySearchResultProvider)entry.value).queryResult().queryResult().suggest();
                if (suggest == null) continue;
                hasSuggestions = true;
                Suggest.group(groupedSuggestions, suggest);
            }
            Suggest suggest = hasSuggestions ? new Suggest(Suggest.Fields.SUGGEST, Suggest.reduce(groupedSuggestions)) : null;
        }
        InternalAggregations aggregations = null;
        if (!queryResults.isEmpty() && firstResult.aggregations() != null && firstResult.aggregations().asList() != null) {
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(queryResults.size());
            for (AtomicArray.Entry entry : queryResults) {
                aggregationsList.add((InternalAggregations)((QuerySearchResultProvider)entry.value).queryResult().aggregations());
            }
            aggregations = InternalAggregations.reduce(aggregationsList, new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService, headersContext));
        }
        InternalProfileShardResults shardResults = null;
        if (!queryResults.isEmpty() && firstResult.profileResults() != null) {
            HashMap<String, List<ProfileShardResult>> profileResults = new HashMap<String, List<ProfileShardResult>>(queryResults.size());
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                String key = ((QuerySearchResultProvider)entry.value).queryResult().shardTarget().toString();
                profileResults.put(key, ((QuerySearchResultProvider)entry.value).queryResult().profileResults());
            }
            shardResults = new InternalProfileShardResults(profileResults);
        }
        if (aggregations != null && (pipelineAggregators = firstResult.pipelineAggregators()) != null) {
            ArrayList<InternalAggregation> arrayList = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(aggregations.asList(), PipelineAggregator.AGGREGATION_TRANFORM_FUNCTION));
            for (SiblingPipelineAggregator pipelineAggregator : pipelineAggregators) {
                InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations(arrayList), new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService, headersContext));
                arrayList.add(newAgg);
            }
            aggregations = new InternalAggregations(arrayList);
        }
        InternalSearchHits searchHits = new InternalSearchHits(hits.toArray(new InternalSearchHit[hits.size()]), totalHits, maxScore);
        return new InternalSearchResponse(searchHits, aggregations, (Suggest)var16_24, shardResults, timedOut, terminatedEarly);
    }
}

