/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_PINYIN_API_H
#define __FCITX_MODULE_FCITX_PINYIN_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "pydef.h"
#include "fcitx-utils/keysymgen.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-pinyin", Pinyin)

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, LoadBaseDict, 0)
static inline void
FcitxPinyinLoadBaseDict(FcitxInstance *instance)
{
    FCITX_DEF_MODULE_ARGS(args);
    FcitxPinyinInvokeLoadBaseDict(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, GetPyByHZ, 1)
static inline void
FcitxPinyinGetPyByHZ(FcitxInstance *instance, const char* _arg0, char* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, char*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxPinyinInvokeGetPyByHZ(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, DoInput, 2)
static inline void
FcitxPinyinDoInput(FcitxInstance *instance, const FcitxKeySym* _arg0, const unsigned int* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const FcitxKeySym*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const unsigned int*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxPinyinInvokeDoInput(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, GetCandwords, 3)
static inline void
FcitxPinyinGetCandwords(FcitxInstance *instance)
{
    FCITX_DEF_MODULE_ARGS(args);
    FcitxPinyinInvokeGetCandwords(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, GetFindString, 4)
static inline char*
FcitxPinyinGetFindString(FcitxInstance *instance)
{
    void *result = NULL;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxPinyinInvokeGetFindString(instance, args);
    FCITX_RETURN_FROM_PTR(char*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, Reset, 5)
static inline void
FcitxPinyinReset(FcitxInstance *instance)
{
    FCITX_DEF_MODULE_ARGS(args);
    FcitxPinyinInvokeReset(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, SP2QP, 6)
static inline char*
FcitxPinyinSP2QP(FcitxInstance *instance, const char* _arg0)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    result = FcitxPinyinInvokeSP2QP(instance, args);
    FCITX_RETURN_FROM_PTR(char*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Pinyin, AddUserPhrase, 7)
static inline void
FcitxPinyinAddUserPhrase(FcitxInstance *instance, const char* _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxPinyinInvokeAddUserPhrase(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
