# pkg-config
complete -f -c pkg-config -l modversion --description 'Print versions of the specified libraries'
complete -f -c pkg-config -l version --description 'Display the version of pkg-config and quit'
complete -f -c pkg-config -l help --description 'Displays a help message and quit'
complete -f -c pkg-config -l print-errors --description 'Print message when errors occur'
complete -f -c pkg-config -l silence-errors --description 'Stay quiet when errors occur'
complete -f -c pkg-config -l errors-to-stdout --description 'Print errors to stdout instead of stderr'
complete -f -c pkg-config -l debug --description 'Print debugging information'
complete -f -c pkg-config -l cflags --description 'Print pre-processor and compile flags for the specified libraries'
complete -f -c pkg-config -l cflags-only-I --description 'This prints the -I part of "--cflags".'
complete -f -c pkg-config -l libs --description 'Print link flags'
complete -f -c pkg-config -l libs-only-L --description 'This prints the -L/-R part of "--libs".'
complete -f -c pkg-config -l libs-only-l --description 'This prints the -l part of "--libs"'
# TODO: Something like 'pkg-config --print-variables $lib' should offer the options here - the difficulty is determining $lib
complete -f -c pkg-config -l variable --description 'This returns the value of a variable defined in a package\'s .pc file'
complete -f -c pkg-config -l define-variable --description 'This sets a global value for a variable'
complete -f -c pkg-config -l print-variables --description 'Returns a list of all variables defined in the package'
complete -f -c pkg-config -l uninstalled --description 'Return success if any -uninstalled packages are used'
complete -f -c pkg-config -l max-version --description 'Test if a package has at most the specified version'
complete -f -c pkg-config -l atleast-version --description 'Test if a package has at least this version'
complete -f -c pkg-config -l exact-version --description 'Test if a package has exactly this version'
complete -f -c pkg-config -l exists --description 'Test if a package exists'
complete -f -c pkg-config -l static --description 'Output libraries suitable for static linking'
complete -f -c pkg-config -l list-all --description 'List all modules found in the pkg-config path'
complete -f -c pkg-config -l print-provides --description 'List all modules the given packages provides'
complete -f -c pkg-config -l print-requires --description 'List all modules the given packages requires'
complete -f -c pkg-config -l print-requires-private --description 'List all modules the given packages requires for static linking'
complete -f -c pkg-config -a '(command pkg-config --list-all | string replace -r " (.*)" "\t\$1")'
