{$MACRO ON}

(******************************************************************************
 *
 * Copyright (c) 1995-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 *
 * File: Category.h
 *
 * Release: Palm OS SDK 4.0 (63220)
 *
 * Description:
 *   This file defines category structures and routines.

 *
 * History:
 *    03/07/95 art   Created by Art Lamb
 *    07/14/99 bob   Fix up const junk
 *    08/12/99 gap   Add new constants categoryHideEditCategory & categoryDefaultEditCategoryString.
 *    11/13/00 kwk   The listP param for CategoryCreateList[V10] is not const.
 *
 *****************************************************************************)

unit category;

interface

uses  palmos, coretraps, datamgr, control, list, form;

// Note: although these constants are in the range of system resource IDs, the are actually
// constants passed to CategoryCreateList, CategorySelect, and CategoryFreeList which will
// produce the desired action.  The reason the constants are in this range is to keep them
// out of the numeric range that developers can use for resource IDs in the attempt to avoid
// conflicts.

const
  categoryHideEditCategory          = 10000;
  categoryDefaultEditCategoryString = 10001;

type
  AppInfoType = record
    renamedCategories: UInt16;
    categoryLabels: array [0..dmRecNumCategories-1, 0..dmCategoryLength-1] of Char;
    categoryUniqIDs: array [0..dmRecNumCategories-1] of UInt8;
    lastUniqID: UInt8; // Uniq IDs generated by the device are between
                       // 0 - 127.  Those from the PC are 128 - 255.
    padding: UInt8;
  end;
  AppInfoTag = AppInfoType;
  AppInfoPtr = ^AppInfoType;

procedure CategoryCreateListV10(db: DmOpenRef; lst: ListPtr; currentCategory: UInt16; showAll: Boolean); syscall sysTrapCategoryCreateListV10;

procedure CategoryCreateList(db: DmOpenRef; listP: ListPtr;
                             currentCategory: UInt16; showAll, showUneditables: Boolean;
                             numUneditableCategories: UInt8; editingStrID: UInt32; resizeList: Boolean); syscall sysTrapCategoryCreateList;

procedure CategoryFreeListV10(db: DmOpenRef; lst: ListPtr); syscall sysTrapCategoryFreeListV10;

procedure CategoryFreeList(db: DmOpenRef; listP: ListPtr; showAll: Boolean; editingStrID: UInt32); syscall sysTrapCategoryFreeList;

function CategoryFind(db: DmOpenRef; const name: PChar): UInt16; syscall sysTrapCategoryFind;

procedure CategoryGetName(db: DmOpenRef; index: UInt16; name: PChar); syscall sysTrapCategoryGetName;

function CategoryEditV10(db: DmOpenRef; var category: UInt16): Boolean; syscall sysTrapCategoryEditV10;

function CategoryEditV20(db: DmOpenRef; var category: UInt16; titleStrID: UInt32): Boolean; syscall sysTrapCategoryEditV20;

function CategoryEdit(db: DmOpenRef; var category: UInt16; titleStrID: UInt32; numUneditableCategories: UInt8): Boolean; syscall sysTrapCategoryEdit;

function CategorySelectV10(db: DmOpenRef; const frm: FormPtr; ctlID, lstID: UInt16; title: Boolean;
                           var categoryP: UInt16; categoryName: PChar): Boolean; syscall sysTrapCategorySelectV10;

function CategorySelect(db: DmOpenRef; const frm: FormPtr; ctlID, lstID: UInt16; title: Boolean; var categoryP: UInt16;
                        categoryName: PChar; numUneditableCategories: UInt8; editingStrID: UInt32): Boolean; syscall sysTrapCategorySelect;

function CategoryGetNext(db: DmOpenRef; index: UInt16): UInt16; syscall sysTrapCategoryGetNext;

procedure CategorySetTriggerLabel(ctl: ControlPtr; name: PChar); syscall sysTrapCategorySetTriggerLabel;

procedure CategoryTruncateName(name: PChar; maxWidth: UInt16); syscall sysTrapCategoryTruncateName;

procedure CategoryInitialize(appInfoP: AppInfoPtr; localizedAppInfoStrID: UInt16); syscall sysTrapCategoryInitialize;

procedure CategorySetName(db: DmOpenRef; index: UInt16; const nameP: PChar); syscall sysTrapCategorySetName;

implementation

end.
