/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public final class MapEditorController {
    private static final Logger logger = Logger.getLogger(MapEditorController.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;
    private IMapTransform currentMapTransform = null;

    public MapEditorController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
    }

    public void startMapEditor() {
        try {
            Specification specification = this.getDefaultSpecification();
            this.freeColClient.setMapEditor(true);
            FreeColServer freeColServer = new FreeColServer(false, false, specification, 0, null);
            this.freeColClient.setFreeColServer(freeColServer);
            ServerGame game = freeColServer.getGame();
            this.requireNativeNations(game);
            this.freeColClient.setGame(game);
            this.freeColClient.setMyPlayer(null);
            this.freeColClient.getSoundController().playSound(null);
            this.gui.closeMainPanel();
            this.gui.closeMenus();
            this.freeColClient.setInGame(true);
            this.gui.changeViewMode(1);
            this.gui.startMapEditorGUI();
        }
        catch (IOException e) {
            this.gui.showErrorMessage("server.initialize");
            return;
        }
    }

    public Specification getDefaultSpecification() throws IOException {
        return FreeCol.loadSpecification(FreeCol.getTCFile(), FreeCol.getAdvantages(), FreeCol.getDifficulty());
    }

    public void setMapTransform(IMapTransform mt) {
        this.currentMapTransform = mt;
        this.gui.updateMapControls();
    }

    public IMapTransform getMapTransform() {
        return this.currentMapTransform;
    }

    public void transform(Tile t) {
        if (this.currentMapTransform != null) {
            this.currentMapTransform.transform(t);
        }
    }

    public void newMap() {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        this.gui.removeInGameComponents();
        OptionGroup mgo = this.gui.showMapGeneratorOptionsDialog(true);
        if (mgo == null) {
            return;
        }
        game.setMapGeneratorOptions(mgo);
        Map map = this.freeColClient.getFreeColServer().getMapGenerator().createMap(new LogBuilder(-1));
        this.requireNativeNations(game);
        this.gui.setFocus(game.getMap().getTile(1, 1));
        this.gui.updateMenuBar();
        this.gui.refresh();
    }

    public void saveGame() {
        File file = this.gui.showSaveDialog(FreeColDirectories.getSaveDirectory(), "my_map.fsg");
        if (file != null) {
            this.saveGame(file);
        }
    }

    public void saveGame(final File file) {
        Game game = this.freeColClient.getGame();
        Map map = game.getMap();
        map.resetContiguity();
        map.resetHighSeasCount();
        map.resetLayers();
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        Thread t = new Thread("FreeColClient:Saving Map"){

            @Override
            public void run() {
                try {
                    BufferedImage thumb = MapEditorController.this.gui.createMiniMapThumbNail();
                    MapEditorController.this.freeColClient.getFreeColServer().saveMapEditorGame(file, thumb);
                    SwingUtilities.invokeLater(() -> {
                        MapEditorController.this.gui.closeStatusPanel();
                        MapEditorController.this.gui.requestFocusInWindow();
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(() -> MapEditorController.this.gui.showErrorMessage(FreeCol.badSave(file)));
                }
            }
        };
        t.start();
    }

    public void loadGame() {
        File file = this.gui.showLoadSaveFileDialog();
        if (file != null) {
            this.loadGame(file);
        }
    }

    public void requireNativeNations(Game game) {
        Specification spec = game.getSpecification();
        for (Nation n : spec.getIndianNations()) {
            Player p = game.getPlayerByNation(n);
            if (p != null) continue;
            p = new ServerPlayer(game, false, n, null, null);
            game.addPlayer(p);
        }
    }

    public void loadGame(File file) {
        File theFile = file;
        this.freeColClient.setMapEditor(true);
        this.gui.showStatusPanel(Messages.message("status.loadingGame"));
        Runnable loadGameJob = () -> {
            class ErrorJob
            implements Runnable {
                private final StringTemplate template;

                ErrorJob(StringTemplate template) {
                    this.template = template;
                }

                @Override
                public void run() {
                    MapEditorController.this.gui.closeMenus();
                    MapEditorController.this.gui.showErrorMessage(this.template);
                }
            }
            FreeColServer freeColServer = this.freeColClient.getFreeColServer();
            try {
                Specification spec = this.getDefaultSpecification();
                ServerGame game = FreeColServer.readGame(new FreeColSavegameFile(theFile), spec, freeColServer);
                this.freeColClient.setGame(game);
                this.requireNativeNations(game);
                SwingUtilities.invokeLater(() -> {
                    this.gui.closeStatusPanel();
                    this.gui.setFocus(this.freeColClient.getGame().getMap().getTile(1, 1));
                    this.gui.updateMenuBar();
                    this.gui.refresh();
                });
            }
            catch (FreeColException e) {
                this.reloadMainPanel();
                SwingUtilities.invokeLater(new ErrorJob(StringTemplate.name(e.getMessage())));
            }
            catch (FileNotFoundException e) {
                this.reloadMainPanel();
                SwingUtilities.invokeLater(new ErrorJob(StringTemplate.key("server.fileNotFound")));
            }
            catch (IOException e) {
                this.reloadMainPanel();
                SwingUtilities.invokeLater(new ErrorJob(StringTemplate.key("server.initialize")));
            }
            catch (XMLStreamException e) {
                this.reloadMainPanel();
                SwingUtilities.invokeLater(new ErrorJob(FreeCol.badLoad(theFile)));
            }
        };
        this.freeColClient.setWork(loadGameJob);
    }

    private void reloadMainPanel() {
        SwingUtilities.invokeLater(() -> {
            this.gui.closeMainPanel();
            this.gui.showMainPanel(null);
            this.freeColClient.getSoundController().playSound("sound.intro.general");
        });
    }

    public static interface IMapTransform {
        public void transform(Tile var1);
    }
}

