/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.animation.UnitImageAnimation;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

final class UnitAttackAnimation {
    private final FreeColClient freeColClient;
    private final Unit attacker;
    private final Unit defender;
    private final Tile attackerTile;
    private final Tile defenderTile;
    private final boolean success;
    private boolean mirror = false;

    public UnitAttackAnimation(FreeColClient freeColClient, Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.freeColClient = freeColClient;
        this.attacker = attacker;
        this.defender = defender;
        this.attackerTile = attackerTile;
        this.defenderTile = defenderTile;
        this.success = success;
    }

    private SimpleZippedAnimation getAnimation(String startStr, float scale, Direction direction) {
        String specialId = startStr + direction.toString().toLowerCase();
        SimpleZippedAnimation sza = ResourceManager.getSimpleZippedAnimation(specialId, scale);
        if (sza != null) {
            this.mirror = false;
            return sza;
        }
        specialId = startStr + direction.getEWMirroredDirection().toString().toLowerCase();
        sza = ResourceManager.getSimpleZippedAnimation(specialId, scale);
        if (sza != null) {
            this.mirror = true;
            return sza;
        }
        return null;
    }

    private SimpleZippedAnimation getAnimation(Unit unit, Direction direction) {
        float scale = ((SwingGUI)this.freeColClient.getGUI()).getMapScale();
        String roleStr = unit.hasDefaultRole() ? "" : "." + unit.getRoleSuffix();
        String startStr = "animation.unit." + unit.getType().getId() + roleStr + ".attack.";
        SimpleZippedAnimation sza = this.getAnimation(startStr, scale, direction);
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getNextDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getPreviousDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getNextDirection().getNextDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getPreviousDirection().getPreviousDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getNextDirection().getNextDirection().getNextDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getPreviousDirection().getPreviousDirection().getPreviousDirection());
        if (sza != null) {
            return sza;
        }
        sza = this.getAnimation(startStr, scale, direction.getReverseDirection());
        return sza;
    }

    public void animate() {
        SimpleZippedAnimation sza;
        SwingGUI gui = (SwingGUI)this.freeColClient.getGUI();
        Direction direction = this.attackerTile.getDirection(this.defenderTile);
        if (this.freeColClient.getAnimationSpeed(this.attacker.getOwner()) > 0 && (sza = this.getAnimation(this.attacker, direction)) != null) {
            new UnitImageAnimation(gui, this.attacker, this.attackerTile, sza, this.mirror).animate();
        }
        if (!this.success && this.freeColClient.getAnimationSpeed(this.defender.getOwner()) > 0 && (sza = this.getAnimation(this.defender, direction = direction.getReverseDirection())) != null) {
            new UnitImageAnimation(gui, this.defender, this.defenderTile, sza, this.mirror).animate();
        }
    }
}

