/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Point;
import java.awt.Rectangle;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

final class UnitMoveAnimation {
    private static final int ANIMATION_DELAY = 33;
    private final FreeColClient freeColClient;
    private final Unit unit;
    private final Tile sourceTile;
    private final Tile destinationTile;

    public UnitMoveAnimation(FreeColClient freeColClient, Unit unit, Tile sourceTile, Tile destinationTile) {
        this.freeColClient = freeColClient;
        this.unit = unit;
        this.sourceTile = sourceTile;
        this.destinationTile = destinationTile;
    }

    public void animate() {
        int movementSpeed = this.freeColClient.getAnimationSpeed(this.unit.getOwner());
        SwingGUI gui = (SwingGUI)this.freeColClient.getGUI();
        Point srcP = gui.getTilePosition(this.sourceTile);
        Point dstP = gui.getTilePosition(this.destinationTile);
        if (srcP == null || dstP == null || movementSpeed <= 0) {
            return;
        }
        float scale = gui.getMapScale();
        int movementRatio = (int)(Math.pow(2.0, movementSpeed + 1) * (double)scale);
        Rectangle r1 = gui.getTileBounds(this.sourceTile);
        Rectangle r2 = gui.getTileBounds(this.destinationTile);
        Rectangle bounds = r1.union(r2);
        gui.executeWithUnitOutForAnimation(this.unit, this.sourceTile, unitLabel -> {
            int stepX;
            int labelWidth = unitLabel.getWidth();
            int labelHeight = unitLabel.getHeight();
            Point srcPoint = gui.calculateUnitLabelPositionInTile(labelWidth, labelHeight, srcP);
            Point dstPoint = gui.calculateUnitLabelPositionInTile(labelWidth, labelHeight, dstP);
            double xratio = (double)ImageLibrary.TILE_SIZE.width / (double)ImageLibrary.TILE_SIZE.height;
            int n = srcPoint.getX() == dstPoint.getX() ? 0 : (stepX = srcPoint.getX() > dstPoint.getX() ? -1 : 1);
            int stepY = srcPoint.getY() == dstPoint.getY() ? 0 : (srcPoint.getY() > dstPoint.getY() ? -1 : 1);
            gui.paintImmediatelyCanvasInItsBounds();
            int dropFrames = 0;
            Point point = srcPoint;
            while (!point.equals(dstPoint)) {
                long time = System.currentTimeMillis();
                point.x = (int)((double)point.x + (double)stepX * xratio * (double)movementRatio);
                point.y += stepY * movementRatio;
                if (stepX < 0 && point.x < dstPoint.x || stepX > 0 && point.x > dstPoint.x) {
                    point.x = dstPoint.x;
                }
                if (stepY < 0 && point.y < dstPoint.y || stepY > 0 && point.y > dstPoint.y) {
                    point.y = dstPoint.y;
                }
                if (dropFrames <= 0) {
                    unitLabel.setLocation(point);
                    gui.paintImmediatelyCanvasIn(bounds);
                    int timeTaken = (int)(System.currentTimeMillis() - time);
                    int waitTime = 33 - timeTaken;
                    if (waitTime > 0) {
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        dropFrames = 0;
                        continue;
                    }
                    dropFrames = timeTaken / 33 - 1;
                    continue;
                }
                --dropFrames;
            }
        });
    }
}

