/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public class InformationPanel
extends FreeColPanel {
    public InformationPanel(FreeColClient freeColClient, String text, FreeColObject fco, ImageIcon image) {
        this(freeColClient, new String[]{text}, new FreeColObject[]{fco}, new ImageIcon[]{image});
    }

    public InformationPanel(FreeColClient freeColClient, String[] texts, FreeColObject[] fcos, ImageIcon[] images) {
        super(freeColClient, new MigLayout("wrap 1, insets 200 10 10 10", "[510]", "[242]20[20]"));
        SwingGUI gui = this.getGUI();
        MigPanel textPanel = new MigPanel();
        textPanel.setOpaque(false);
        textPanel.setLayout(new MigLayout("wrap 2", "", "top"));
        for (int i = 0; i < texts.length; ++i) {
            if (images != null && images[i] != null) {
                textPanel.add(new JLabel(images[i]));
                textPanel.add(Utility.getDefaultTextArea(texts[i], new Dimension(475 - images[i].getIconWidth(), 185)));
            } else {
                textPanel.add((Component)Utility.getDefaultTextArea(texts[i], new Dimension(475, 185)), "skip");
            }
            StringTemplate disp = this.displayLabel(fcos[i]);
            if (disp == null) continue;
            JButton button = Utility.localizedButton(StringTemplate.template("informationPanel.display").addStringTemplate("%object%", disp));
            FreeColObject fco = fcos[i];
            button.addActionListener(ae -> gui.displayObject(fco));
            textPanel.add((Component)button, "skip");
        }
        JScrollPane scrollPane = new JScrollPane(textPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.setBorder(null);
        this.add(scrollPane);
        this.add((Component)this.okButton, "tag ok");
    }

    private StringTemplate displayLabel(FreeColObject fco) {
        return fco instanceof Tile && ((Tile)fco).hasSettlement() ? this.displayLabel(((Tile)fco).getSettlement()) : (fco instanceof Unit ? this.displayLabel((FreeColObject)((Object)((Unit)fco).getLocation())) : (fco instanceof Location ? ((Location)((Object)fco)).getLocationLabelFor(this.getMyPlayer()) : null));
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(ResourceManager.getImage("image.skin.InformationPanel"), 0, 0, this);
    }
}

