/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.TileType;

public class TerrainDetailPanel
extends ColopediaGameObjectTypePanel<TileType> {
    public TerrainDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.TERRAIN.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        for (TileType t : this.getSpecification().getTileTypeList()) {
            BufferedImage tile = SwingGUI.createTileImageWithOverlayAndForest(t, new Dimension(-1, ImageLibrary.ICON_SIZE.height));
            BufferedImage image = new BufferedImage(((Image)tile).getWidth(null), ImageLibrary.ICON_SIZE.height, 2);
            Graphics2D g = image.createGraphics();
            g.drawImage((Image)tile, 0, (ImageLibrary.ICON_SIZE.height - ((Image)tile).getHeight(null)) / 2, null);
            g.dispose();
            ImageIcon icon = new ImageIcon(image);
            node.add(this.buildItem(t, icon));
        }
        root.add(node);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        TileType tileType = this.getSpecification().getTileType(id);
        panel.setLayout(new MigLayout("wrap 4, gap 20"));
        String movementCost = String.valueOf(tileType.getBasicMoveCost() / 3);
        String defenseBonus = Messages.message("none");
        Set<Modifier> defenceModifiers = tileType.getDefenceModifiers();
        if (!defenceModifiers.isEmpty()) {
            defenseBonus = ModifierFormat.getModifierAsString(defenceModifiers.iterator().next());
        }
        JLabel nameLabel = Utility.localizedHeaderLabel(tileType, FontLibrary.FontSize.SMALL);
        panel.add((Component)nameLabel, "span, align center");
        panel.add((Component)Utility.localizedLabel("colopedia.terrain.terrainImage"), "spany 3");
        BufferedImage terrainImage = SwingGUI.createTileImageWithOverlayAndForest(tileType, ImageLibrary.TILE_OVERLAY_SIZE);
        panel.add((Component)new JLabel(new ImageIcon(terrainImage)), "spany 3");
        List<ResourceType> resourceList = tileType.getResourceTypes();
        if (!resourceList.isEmpty()) {
            panel.add(Utility.localizedLabel("colopedia.terrain.resource"));
            if (resourceList.size() > 1) {
                panel.add((Component)this.getResourceButton(resourceList.get(0)), "split " + resourceList.size());
                for (int index = 1; index < resourceList.size(); ++index) {
                    panel.add(this.getResourceButton(resourceList.get(index)));
                }
            } else {
                panel.add(this.getResourceButton(resourceList.get(0)));
            }
        } else {
            panel.add((Component)new JLabel(), "wrap");
        }
        panel.add(Utility.localizedLabel("colopedia.terrain.movementCost"));
        panel.add(new JLabel(movementCost));
        panel.add(Utility.localizedLabel("colopedia.terrain.defenseBonus"));
        panel.add(new JLabel(defenseBonus));
        panel.add(Utility.localizedLabel("colopedia.terrain.unattendedProduction"));
        this.addProduction(panel, tileType.getPossibleProduction(true));
        panel.add(Utility.localizedLabel("colopedia.terrain.colonistProduction"));
        this.addProduction(panel, tileType.getPossibleProduction(false));
        panel.add(Utility.localizedLabel("colopedia.terrain.description"));
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(tileType)), "span, growx");
    }

    private void addProduction(JPanel panel, List<AbstractGoods> production) {
        if (production.isEmpty()) {
            panel.add((Component)new JLabel(), "wrap");
        } else {
            AbstractGoods ag;
            Iterator<AbstractGoods> it = production.iterator();
            while (it.hasNext()) {
                ag = it.next();
                if (ag.getAmount() > 0) continue;
                it.remove();
            }
            ag = production.get(0);
            if (production.size() > 1) {
                panel.add((Component)this.getGoodsButton(ag.getType(), ag.getAmount()), "span, split " + production.size());
                for (int index = 1; index < production.size(); ++index) {
                    ag = production.get(index);
                    panel.add(this.getGoodsButton(ag.getType(), ag.getAmount()));
                }
            } else {
                panel.add((Component)this.getGoodsButton(ag.getType(), ag.getAmount()), "span");
            }
        }
    }
}

