/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public class HistoryEvent
extends StringTemplate {
    private Turn turn;
    private HistoryEventType eventType;
    private String playerId;
    private int score;
    private static final String EVENT_TYPE_TAG = "eventType";
    private static final String PLAYER_ID_TAG = "playerId";
    private static final String SCORE_TAG = "score";
    private static final String TURN_TAG = "turn";

    public HistoryEvent(Turn turn, HistoryEventType eventType, Player player) {
        super(eventType.getDescriptionKey(), null, StringTemplate.TemplateType.TEMPLATE);
        this.turn = turn;
        this.eventType = eventType;
        this.playerId = player == null ? null : player.getId();
        this.score = 0;
    }

    public HistoryEvent(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public HistoryEvent(Element element) {
        this.readFromXMLElement(element);
    }

    public final Turn getTurn() {
        return this.turn;
    }

    public final HistoryEventType getEventType() {
        return this.eventType;
    }

    public static final HistoryEventType getEventTypeFromStance(Stance stance) {
        switch (stance) {
            case WAR: {
                return HistoryEventType.DECLARE_WAR;
            }
            case CEASE_FIRE: {
                return HistoryEventType.CEASE_FIRE;
            }
            case PEACE: {
                return HistoryEventType.MAKE_PEACE;
            }
            case ALLIANCE: {
                return HistoryEventType.FORM_ALLIANCE;
            }
        }
        return null;
    }

    public final String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public final int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public HistoryEvent add(String key, String value) {
        return (HistoryEvent)super.add(key, value);
    }

    @Override
    public HistoryEvent addName(String key, String value) {
        return (HistoryEvent)super.addName(key, value);
    }

    @Override
    public HistoryEvent addNamed(String key, Named value) {
        return (HistoryEvent)super.addNamed(key, value);
    }

    @Override
    public HistoryEvent addAmount(String key, Number amount) {
        return (HistoryEvent)super.addAmount(key, amount);
    }

    @Override
    public HistoryEvent addStringTemplate(String key, StringTemplate template) {
        return (HistoryEvent)super.addStringTemplate(key, template);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HistoryEvent) {
            HistoryEvent h = (HistoryEvent)o;
            return this.turn == h.turn && this.eventType == h.eventType && Utils.equals(this.playerId, h.playerId) && this.score == h.score;
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TURN_TAG, this.turn.getNumber());
        xw.writeAttribute(EVENT_TYPE_TAG, this.eventType);
        if (this.playerId != null) {
            xw.writeAttribute(PLAYER_ID_TAG, this.playerId);
        }
        xw.writeAttribute(SCORE_TAG, this.score);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.turn = new Turn(xr.getAttribute(TURN_TAG, 0));
        this.eventType = xr.getAttribute(EVENT_TYPE_TAG, HistoryEventType.class, null);
        this.playerId = xr.getAttribute(PLAYER_ID_TAG, null);
        this.score = xr.getAttribute(SCORE_TAG, 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" ").append(this.eventType).append(" (").append(this.turn.getYear()).append(")");
        if (this.playerId != null) {
            sb.append(" playerId=").append(this.playerId).append(" score=").append(this.score);
        }
        sb.append(" ").append(super.toString()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return HistoryEvent.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "historyEvent";
    }

    public static enum HistoryEventType implements Named
    {
        DISCOVER_NEW_WORLD,
        DISCOVER_REGION,
        MEET_NATION,
        CITY_OF_GOLD,
        FOUND_COLONY,
        ABANDON_COLONY,
        CONQUER_COLONY,
        COLONY_DESTROYED,
        COLONY_CONQUERED,
        DESTROY_SETTLEMENT,
        DESTROY_NATION,
        NATION_DESTROYED,
        FOUNDING_FATHER,
        DECLARE_INDEPENDENCE,
        INDEPENDENCE,
        SPANISH_SUCCESSION,
        DECLARE_WAR,
        CEASE_FIRE,
        MAKE_PEACE,
        FORM_ALLIANCE;


        private String getKey() {
            return "historyEventType." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

