/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Turn;
import org.w3c.dom.Element;

public final class LastSale
extends FreeColObject {
    private Turn when;
    private int price;
    private static final String PRICE_TAG = "price";
    private static final String WHEN_TAG = "when";

    public LastSale(Location where, GoodsType what, Turn when, int price) {
        this(LastSale.makeKey(where, what), when, price);
    }

    public LastSale(String id, Turn when, int price) {
        this.setId(id);
        this.when = when;
        this.price = price;
    }

    public LastSale(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public LastSale(Element element) {
        this.readFromXMLElement(element);
    }

    public Turn getWhen() {
        return this.when;
    }

    public int getPrice() {
        return this.price;
    }

    public static String makeKey(Location where, GoodsType what) {
        return where.getId() + "-" + what.getId();
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof LastSale) {
            LastSale ls = (LastSale)other;
            cmp = this.getWhen().getNumber() - ls.getWhen().getNumber();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WHEN_TAG, this.when.getNumber());
        xw.writeAttribute(PRICE_TAG, this.price);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.when = new Turn(xr.getAttribute(WHEN_TAG, 0));
        this.price = xr.getAttribute(PRICE_TAG, 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" when=").append(this.when).append(" price=").append(this.price).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return LastSale.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "lastSale";
    }
}

