/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.server.control.ChangeSet;

public abstract class TransactionSession {
    private static final Logger logger = Logger.getLogger(TransactionSession.class.getName());
    protected static final Map<String, TransactionSession> allSessions = new HashMap<String, TransactionSession>();
    private boolean completed;

    protected TransactionSession(String key) {
        if (allSessions.get(key) != null) {
            throw new IllegalArgumentException("Duplicate session: " + key);
        }
        this.completed = false;
        allSessions.put(key, this);
        logger.finest("Created session: " + key);
    }

    public void complete(ChangeSet cs) {
        this.completed = true;
    }

    protected static String makeSessionKey(Class type, String o1, String o2) {
        return type + "-" + o1 + "-" + o2;
    }

    protected static String makeSessionKey(Class type, FreeColGameObject o1, FreeColGameObject o2) {
        return TransactionSession.makeSessionKey(type, o1.getId(), o2.getId());
    }

    public static void completeAll(ChangeSet cs) {
        for (TransactionSession ts : allSessions.values()) {
            if (ts.completed) continue;
            ts.complete(cs);
        }
        TransactionSession.clearAll();
    }

    public static void clearAll() {
        allSessions.clear();
    }

    public static <T extends TransactionSession> T lookup(Class<T> type, FreeColGameObject o1, FreeColGameObject o2) {
        return TransactionSession.lookup(type, o1.getId(), o2.getId());
    }

    public static <T extends TransactionSession> T lookup(Class<T> type, String s1, String s2) {
        String key = TransactionSession.makeSessionKey(type, s1, s2);
        TransactionSession ts = allSessions.get(key);
        if (ts != null && ts.completed) {
            allSessions.remove(key);
            ts = null;
        }
        return (T)(ts == null ? null : (TransactionSession)type.cast(ts));
    }
}

