/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.CombinedAttribute;
import com.lightdev.app.shtm.SizeSelectorPanel;
import com.lightdev.app.shtm.Util;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;

class BoundariesPanel
extends JPanel
implements AttributeComponent {
    private final Vector components = new Vector();
    private CombinedAttribute ca;
    private String originalValue;
    private int setValueCalls = 0;
    private final Object key;

    public BoundariesPanel(Object attrKey) {
        this.key = attrKey;
        GridBagLayout g = new GridBagLayout();
        this.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        Util.addGridBagComponent(this, new JLabel(Util.getResourceString("topLabel")), g, c, 0, 0, 13);
        Util.addGridBagComponent(this, new JLabel(Util.getResourceString("rightLabel")), g, c, 2, 0, 13);
        Util.addGridBagComponent(this, new JLabel(Util.getResourceString("bottomLabel")), g, c, 0, 1, 13);
        Util.addGridBagComponent(this, new JLabel(Util.getResourceString("leftLabel")), g, c, 2, 1, 13);
        this.addSizeSelector(g, c, attrKey, 1, 0);
        this.addSizeSelector(g, c, attrKey, 3, 0);
        this.addSizeSelector(g, c, attrKey, 1, 1);
        this.addSizeSelector(g, c, attrKey, 3, 1);
    }

    private void addSizeSelector(GridBagLayout g, GridBagConstraints c, Object attr, int x, int y) {
        SizeSelectorPanel ssp = new SizeSelectorPanel(attr, null, false, 1);
        Util.addGridBagComponent(this, ssp, g, c, x, y, 17);
        this.components.addElement(ssp);
    }

    public boolean setValue(AttributeSet a) {
        boolean success = true;
        this.ca = new CombinedAttribute(this.key, a, true);
        if (++this.setValueCalls < 2) {
            this.originalValue = this.ca.getAttribute();
        }
        for (int i = 0; i < this.components.size(); ++i) {
            SizeSelectorPanel ssp = (SizeSelectorPanel)this.components.elementAt(i);
            ssp.setValue(this.ca.getAttribute(i));
        }
        return true;
    }

    public AttributeSet getValue() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        for (int i = 0; i < this.components.size(); ++i) {
            SizeSelectorPanel ssp = (SizeSelectorPanel)this.components.elementAt(i);
            if (!ssp.valueChanged()) continue;
            this.ca.setAttribute(i, ssp.getAttr());
        }
        String newValue = this.ca.getAttribute();
        if (!this.originalValue.equalsIgnoreCase(newValue)) {
            set.addAttribute(this.key, newValue);
            Util.styleSheet().addCSSAttribute(set, (CSS.Attribute)this.key, newValue);
        }
        return set;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet set = new SimpleAttributeSet();
            for (int i = 0; i < this.components.size(); ++i) {
                SizeSelectorPanel ssp = (SizeSelectorPanel)this.components.elementAt(i);
                this.ca.setAttribute(i, ssp.getAttr());
            }
            String newValue = this.ca.getAttribute();
            set.addAttribute(this.key, newValue);
            Util.styleSheet().addCSSAttribute(set, (CSS.Attribute)this.key, newValue);
            return set;
        }
        return this.getValue();
    }

    public void reset() {
        this.setValueCalls = 0;
        this.originalValue = null;
    }
}

