/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionFactory;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import javax.swing.JComponent;

public class SelectedViewCondition
implements Condition {
    private static String description;
    private static JComponent renderer;
    private static Condition condition;

    public String toString() {
        if (description == null) {
            description = Resources.getInstance().getResourceString("filter_selected_node_view");
        }
        return description;
    }

    @Override
    public boolean checkNode(Controller c, MindMapNode node) {
        NodeView viewer = c.getModeController().getNodeView(node);
        return viewer != null && viewer.isSelected();
    }

    @Override
    public JComponent getListCellRendererComponent() {
        if (renderer == null) {
            renderer = ConditionFactory.createCellRendererComponent(description);
        }
        return renderer;
    }

    public static Condition CreateCondition() {
        if (condition == null) {
            condition = new SelectedViewCondition();
        }
        return condition;
    }

    @Override
    public void save(XMLElement element) {
    }
}

