/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapNode;
import freemind.preferences.FreemindPropertyListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public abstract class CloudAdapter
extends LineAdapter
implements MindMapCloud {
    public static final String RESOURCES_STANDARDCLOUDSTYLE = "standardcloudstyle";
    private static Color standardColor = null;
    private static String standardStyle = null;
    private static CloudAdapterListener listener = null;
    static final Stroke DEF_STROKE = new BasicStroke(3.0f);
    private int iterativeLevel;

    public CloudAdapter(MindMapNode target, FreeMindMain frame) {
        super(target, frame);
        this.NORMAL_WIDTH = 3;
        this.iterativeLevel = -1;
        if (listener == null) {
            listener = new CloudAdapterListener();
            Controller.addPropertyChangeListener(listener);
        }
    }

    private void calcIterativeLevel(MindMapNode target) {
        this.iterativeLevel = 0;
        if (target != null) {
            for (MindMapNode parentNode = target.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                MindMapCloud cloud = parentNode.getCloud();
                if (cloud == null) continue;
                this.iterativeLevel = cloud.getIterativeLevel() + 1;
                break;
            }
        }
    }

    @Override
    public void setTarget(MindMapNode target) {
        super.setTarget(target);
    }

    @Override
    public Color getExteriorColor() {
        return this.getColor().darker();
    }

    @Override
    public int getIterativeLevel() {
        if (this.iterativeLevel == -1) {
            this.calcIterativeLevel(this.target);
        }
        return this.iterativeLevel;
    }

    @Override
    public void changeIterativeLevel(int deltaLevel) {
        if (this.iterativeLevel != -1) {
            this.iterativeLevel += deltaLevel;
        }
    }

    @Override
    public XMLElement save() {
        XMLElement cloud = new XMLElement();
        cloud.setName("cloud");
        if (this.style != null) {
            cloud.setAttribute("STYLE", this.style);
        }
        if (this.color != null) {
            cloud.setAttribute("COLOR", Tools.colorToXml(this.color));
        }
        if (this.width != -1) {
            cloud.setAttribute("WIDTH", Integer.toString(this.width));
        }
        return cloud;
    }

    @Override
    protected Color getStandardColor() {
        return standardColor;
    }

    @Override
    protected void setStandardColor(Color standardColor) {
        CloudAdapter.standardColor = standardColor;
    }

    @Override
    protected String getStandardStyle() {
        return standardStyle;
    }

    @Override
    protected void setStandardStyle(String standardStyle) {
        CloudAdapter.standardStyle = standardStyle;
    }

    @Override
    protected String getStandardColorPropertyString() {
        return "standardcloudcolor";
    }

    @Override
    protected String getStandardStylePropertyString() {
        return RESOURCES_STANDARDCLOUDSTYLE;
    }

    protected static class CloudAdapterListener
    implements FreemindPropertyListener {
        protected CloudAdapterListener() {
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("standardcloudcolor")) {
                standardColor = Tools.xmlToColor(newValue);
            }
            if (propertyName.equals(CloudAdapter.RESOURCES_STANDARDCLOUDSTYLE)) {
                standardStyle = newValue;
            }
        }
    }
}

