/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.controller.actions.generated.instance.DeleteNodeAction;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.PasteAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class DeleteChildAction
extends AbstractAction
implements ActorXml {
    private final MindMapController mMindMapController;
    private String text;

    public DeleteChildAction(MindMapController modeController) {
        super(modeController.getText("remove_node"), new ImageIcon(modeController.getResource("images/editdelete.png")));
        this.text = modeController.getText("remove_node");
        this.mMindMapController = modeController;
        this.mMindMapController.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (MindMapNode node : this.mMindMapController.getSelecteds()) {
            if (!node.isRoot()) continue;
            this.mMindMapController.getController().errorMessage(this.mMindMapController.getFrame().getResourceString("cannot_delete_root"));
            return;
        }
        int showResult = new OptionalDontShowMeAgainDialog(this.mMindMapController.getFrame().getJFrame(), this.mMindMapController.getSelectedView(), "really_remove_node", "confirmation", this.mMindMapController, new OptionalDontShowMeAgainDialog.StandardPropertyHandler(this.mMindMapController.getController(), "delete_nodes_without_question"), 0).show().getResult();
        if (showResult != 0) {
            return;
        }
        this.mMindMapController.cut();
    }

    @Override
    public void act(XmlAction action) {
        DeleteNodeAction deleteNodeAction = (DeleteNodeAction)action;
        NodeAdapter selectedNode = this.mMindMapController.getNodeFromID(deleteNodeAction.getNode());
        this.deleteWithoutUndo(selectedNode);
    }

    public void deleteWithoutUndo(MindMapNode selectedNode) {
        this.removeHooks(selectedNode);
        MindMapNode parent = selectedNode.getParentNode();
        this.mMindMapController.fireNodePreDeleteEvent(selectedNode);
        this.mMindMapController.getModel().getLinkRegistry().deregisterLinkTarget(selectedNode);
        MapView view = this.mMindMapController.getView();
        NodeView nodeView = view.getNodeView(selectedNode);
        view.deselect(nodeView);
        if (view.getSelecteds().size() == 0) {
            int childIndex = parent.getChildPosition(selectedNode);
            NodeView newSelectedView = parent.getChildCount() > childIndex + 1 ? view.getNodeView((MindMapNode)parent.getChildAt(childIndex + 1)) : (childIndex > 0 ? view.getNodeView((MindMapNode)parent.getChildAt(childIndex - 1)) : view.getNodeView(parent));
            view.selectAsTheOnlyOneSelected(newSelectedView);
        }
        this.mMindMapController.removeNodeFromParent(selectedNode);
        this.mMindMapController.fireNodePostDeleteEvent(selectedNode, parent);
    }

    private void removeHooks(MindMapNode selectedNode) {
        ListIterator it = selectedNode.childrenUnfolded();
        while (it.hasNext()) {
            MindMapNode child = (MindMapNode)it.next();
            this.removeHooks(child);
        }
        long currentRun = 0L;
        long timeout = selectedNode.getActivatedHooks().size() * 2 + 2;
        while (selectedNode.getActivatedHooks().size() > 0) {
            PermanentNodeHook hook = (PermanentNodeHook)selectedNode.getActivatedHooks().iterator().next();
            selectedNode.removeHook(hook);
            if (currentRun++ <= timeout) continue;
            throw new IllegalStateException("Timeout reached shutting down the hooks.");
        }
    }

    @Override
    public Class getDoActionClass() {
        return DeleteNodeAction.class;
    }

    public void deleteNode(MindMapNode selectedNode) {
        String newId = this.mMindMapController.getNodeID(selectedNode);
        Transferable copy = this.mMindMapController.copy(selectedNode, true);
        PasteAction.NodeCoordinate coord = new PasteAction.NodeCoordinate(selectedNode, selectedNode.isLeft());
        PasteNodeAction pasteNodeAction = null;
        pasteNodeAction = this.mMindMapController.paste.getPasteNodeAction(copy, coord, null);
        DeleteNodeAction deleteAction = this.getDeleteNodeAction(newId);
        this.mMindMapController.doTransaction(this.text, new ActionPair((XmlAction)deleteAction, (XmlAction)pasteNodeAction));
    }

    public DeleteNodeAction getDeleteNodeAction(String newId) {
        DeleteNodeAction deleteAction = new DeleteNodeAction();
        deleteAction.setNode(newId);
        return deleteAction;
    }
}

