/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.schememode;

import freemind.controller.StructuredMenuHolder;
import freemind.extensions.HookFactory;
import freemind.modes.ControllerAdapter;
import freemind.modes.FreeMindFileDialog;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.common.actions.NewMapAction;
import freemind.modes.schememode.SchemeMapModel;
import freemind.modes.schememode.SchemeNodeModel;
import freemind.modes.schememode.SchemePopupMenu;
import freemind.modes.viewmodes.ViewControllerAdapter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SchemeController
extends ViewControllerAdapter {
    Action newMap = new NewMapAction(this);
    Action open = new ControllerAdapter.OpenAction(this);
    Action save = new ControllerAdapter.SaveAction(this);
    Action saveAs = new ControllerAdapter.SaveAsAction(this);
    Action evaluate = new EvaluateAction();
    private JPopupMenu popupmenu = new SchemePopupMenu(this);

    public SchemeController(Mode mode) {
        super(mode);
    }

    @Override
    public MapAdapter newModel(ModeController modeController) {
        return new SchemeMapModel(this.getFrame(), modeController);
    }

    @Override
    public MindMapNode newNode(Object userObject, MindMap map) {
        return new SchemeNodeModel(this.getFrame(), map);
    }

    @Override
    public boolean saveAs() {
        FreeMindFileDialog chooser = this.getFileChooser();
        int returnVal = chooser.showSaveDialog(this.getView());
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            this.save(f);
            this.updateMapModuleName();
            return true;
        }
        return false;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    @Override
    public void updateMenus(StructuredMenuHolder holder) {
        holder.addAction(this.newMap, "menu_bar/file/open/new");
        holder.addAction(this.open, "menu_bar/file/open/open");
        holder.addAction(this.save, "menu_bar/file/open/save");
        holder.addAction(this.saveAs, "menu_bar/file/open/saveAs");
        holder.addAction(this.evaluate, "menu_bar/edit/edit/evaluate");
        holder.addAction(this.toggleFolded, "menu_bar/edit/edit/toggleFolded");
    }

    @Override
    public HookFactory getHookFactory() {
        throw new IllegalArgumentException("Not implemented yet.");
    }

    private class EvaluateAction
    extends AbstractAction {
        EvaluateAction() {
            super(SchemeController.this.getController().getResourceString("scheme_evaluate"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String rawCode = ((SchemeMapModel)SchemeController.this.getMap()).getCode().trim();
            System.out.println(rawCode);
            StringTokenizer code = new StringTokenizer(rawCode, ",");
            String output = "Output: \n";
            JOptionPane.showMessageDialog(SchemeController.this.getView(), output);
        }
    }
}

