/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeTableModel;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.attributeview.AttributePopupMenu;
import freemind.view.mindmapview.attributeview.AttributeTable;
import freemind.view.mindmapview.attributeview.AttributeTableModelDecoratorAdapter;
import freemind.view.mindmapview.attributeview.AttributeViewScrollPane;
import freemind.view.mindmapview.attributeview.ExtendedAttributeTableModelDecorator;
import freemind.view.mindmapview.attributeview.ReducedAttributeTableModelDecorator;
import java.awt.Color;
import java.awt.EventQueue;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public class AttributeView
implements ChangeListener,
TableModelListener {
    private AttributeTable attributeTable;
    private ReducedAttributeTableModelDecorator reducedAttributeTableModel;
    private ExtendedAttributeTableModelDecorator extendedAttributeTableModel = null;
    private AttributeTableModelDecoratorAdapter currentAttributeTableModel;
    private JScrollPane attributeViewScrollPane;
    private NodeView nodeView;
    private JTableHeader tableHeader;
    private static AttributePopupMenu tablePopupMenu;
    private static final Color HEADER_BACKGROUND;

    public AttributeView(NodeView nodeView) {
        this.nodeView = nodeView;
        this.reducedAttributeTableModel = new ReducedAttributeTableModelDecorator(this);
        this.currentAttributeTableModel = this.reducedAttributeTableModel;
        this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        this.addListeners();
    }

    AttributeRegistry getAttributeRegistry() {
        return this.getNode().getMap().getRegistry().getAttributes();
    }

    public NodeAttributeTableModel getAttributes() {
        return this.getNode().getAttributes();
    }

    public void syncronizeAttributeView() {
        if (this.attributeTable == null && this.currentAttributeTableModel.areAttributesVisible()) {
            this.provideAttributeTable();
        }
    }

    private void provideAttributeTable() {
        if (this.attributeTable == null) {
            this.attributeTable = new AttributeTable(this);
            this.tableHeader = this.attributeTable.getTableHeader();
            this.tableHeader.setBackground(HEADER_BACKGROUND);
            this.addTableModelListeners();
            this.attributeViewScrollPane = new AttributeViewScrollPane(this.attributeTable);
            this.getNodeView().getContentPane().add(this.attributeViewScrollPane);
            this.getAttributes().removeTableModelListener(this);
            this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        }
    }

    private void addListeners() {
        if (this.getNodeView().getModel().getMap().isReadOnly()) {
            return;
        }
        this.getAttributeRegistry().addChangeListener(this);
        this.addTableModelListeners();
    }

    private ModeController getModeController() {
        return this.nodeView.getModel().getMap().getModeController();
    }

    private void addTableModelListeners() {
        if (this.getNodeView().getModel().getMap().isReadOnly()) {
            return;
        }
        ModeController modeController = this.getModeController();
        if (this.attributeTable != null) {
            if (tablePopupMenu == null) {
                tablePopupMenu = ((MindMapController)modeController).getAttributeTablePopupMenu();
            }
            this.getAttributes().getLayout().addColumnWidthChangeListener(this.attributeTable);
            this.attributeTable.addMouseListener(tablePopupMenu);
            this.tableHeader.addMouseListener(tablePopupMenu);
        } else {
            this.getAttributes().addTableModelListener(this);
        }
    }

    private void removeListeners() {
        if (this.getNodeView().getModel().getMap().isReadOnly()) {
            return;
        }
        this.getAttributeRegistry().removeChangeListener(this);
        if (this.attributeTable != null) {
            this.getAttributes().getLayout().removeColumnWidthChangeListener(this.attributeTable);
            this.attributeTable.getParent().remove(this.attributeTable);
            this.attributeTable.getModel().removeTableModelListener(this.attributeTable);
            this.attributeTable.removeMouseListener(tablePopupMenu);
            this.tableHeader.removeMouseListener(tablePopupMenu);
            tablePopupMenu = null;
        } else {
            this.getAttributes().removeTableModelListener(this);
        }
    }

    public void update() {
        if (this.attributeTable != null && this.attributeTable.isVisible()) {
            this.attributeTable.updateAttributeTable();
        }
    }

    public boolean areAttributesVisible() {
        String viewType = this.getViewType();
        return viewType != "hide" && (this.currentAttributeTableModel.areAttributesVisible() || viewType != this.getAttributeRegistry().getAttributeViewType());
    }

    private ExtendedAttributeTableModelDecorator getExtendedAttributeTableModel() {
        if (this.extendedAttributeTableModel == null) {
            this.extendedAttributeTableModel = new ExtendedAttributeTableModelDecorator(this);
        }
        return this.extendedAttributeTableModel;
    }

    private void setViewType(String viewType) {
        JTableHeader currentColumnHeaderView = null;
        if (viewType == "extended") {
            this.currentAttributeTableModel = this.getExtendedAttributeTableModel();
            currentColumnHeaderView = this.tableHeader;
        } else {
            this.currentAttributeTableModel = this.reducedAttributeTableModel;
        }
        if (this.attributeTable != null) {
            this.attributeTable.setModel(this.currentAttributeTableModel);
            this.attributeTable.setTableHeader(currentColumnHeaderView);
            this.attributeViewScrollPane.setColumnHeaderView(currentColumnHeaderView);
            this.attributeViewScrollPane.invalidate();
        }
    }

    public AttributeTableModel getCurrentAttributeTableModel() {
        return this.currentAttributeTableModel;
    }

    MindMapNode getNode() {
        return this.getNodeView().getModel();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        this.reducedAttributeTableModel.stateChanged(null);
        this.getNodeView().revalidate();
    }

    public NodeView getNodeView() {
        return this.nodeView;
    }

    public MapView getMapView() {
        return this.getNodeView().getMap();
    }

    public void viewRemoved() {
        this.removeListeners();
        if (this.reducedAttributeTableModel != null) {
            this.reducedAttributeTableModel.viewRemoved();
        }
        if (this.extendedAttributeTableModel != null) {
            this.extendedAttributeTableModel.viewRemoved();
        }
        if (this.attributeTable != null) {
            this.attributeTable.viewRemoved();
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        MapView map = this.getNodeView().getMap();
        map.getModel().nodeChanged(this.getNode());
    }

    public String getViewType() {
        return this.currentAttributeTableModel == this.reducedAttributeTableModel ? this.getAttributeRegistry().getAttributeViewType() : "extended";
    }

    public void startEditing() {
        if (this.getNode().getMap().isReadOnly()) {
            return;
        }
        this.provideAttributeTable();
        if (this.currentAttributeTableModel == this.reducedAttributeTableModel) {
            this.getExtendedAttributeTableModel();
            this.setViewType("extended");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeView.this.startEditingTable();
            }
        });
    }

    private void startEditingTable() {
        this.attributeTable.requestFocus();
        if (this.currentAttributeTableModel.getRowCount() == 0) {
            this.attributeTable.insertRow(0);
        } else {
            this.attributeTable.changeSelection(0, 0, false, false);
        }
    }

    boolean isPopupShown() {
        return this.attributeTable != null && tablePopupMenu != null && tablePopupMenu.getTable() == this.attributeTable;
    }

    public void stopEditing() {
        String registryAttributeViewType;
        if (this.attributeTable.isEditing()) {
            this.attributeTable.getCellEditor().stopCellEditing();
        }
        if ((registryAttributeViewType = this.getAttributeRegistry().getAttributeViewType()) != this.getViewType()) {
            this.setViewType(registryAttributeViewType);
        }
        this.getNodeView().requestFocus();
    }

    static {
        HEADER_BACKGROUND = UIManager.getColor("TableHeader.background");
    }
}

