/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class VdmxTable
implements Table {
    private DirectoryEntry _de;
    private int _version;
    private int _numRecs;
    private int _numRatios;
    private Ratio[] _ratRange;
    private int[] _offset;
    private Group[] _groups;

    protected VdmxTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numRecs = dataInput.readUnsignedShort();
        this._numRatios = dataInput.readUnsignedShort();
        this._ratRange = new Ratio[this._numRatios];
        for (n = 0; n < this._numRatios; ++n) {
            this._ratRange[n] = new Ratio(dataInput);
        }
        this._offset = new int[this._numRatios];
        for (n = 0; n < this._numRatios; ++n) {
            this._offset[n] = dataInput.readUnsignedShort();
        }
        this._groups = new Group[this._numRecs];
        for (n = 0; n < this._numRecs; ++n) {
            this._groups[n] = new Group(dataInput);
        }
    }

    @Override
    public int getType() {
        return 1447316824;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'VDMX' Table - Precomputed Vertical Device Metrics\n").append("--------------------------------------------------\n").append("  Version:                 ").append(this._version).append("\n").append("  Number of Hgt Records:   ").append(this._numRecs).append("\n").append("  Number of Ratio Records: ").append(this._numRatios).append("\n");
        for (n = 0; n < this._numRatios; ++n) {
            stringBuilder.append("\n    Ratio Record #").append(n + 1).append("\n").append("\tCharSetId     ").append(this._ratRange[n].getBCharSet()).append("\n").append("\txRatio        ").append(this._ratRange[n].getXRatio()).append("\n").append("\tyStartRatio   ").append(this._ratRange[n].getYStartRatio()).append("\n").append("\tyEndRatio     ").append(this._ratRange[n].getYEndRatio()).append("\n").append("\tRecord Offset ").append(this._offset[n]).append("\n");
        }
        stringBuilder.append("\n   VDMX Height Record Groups\n").append("   -------------------------\n");
        for (n = 0; n < this._numRecs; ++n) {
            Group group = this._groups[n];
            stringBuilder.append("   ").append(n + 1).append(".   Number of Hgt Records  ").append(group.getRecs()).append("\n").append("        Starting Y Pel Height  ").append(group.getStartSZ()).append("\n").append("        Ending Y Pel Height    ").append(group.getEndSZ()).append("\n");
            for (int i = 0; i < group.getRecs(); ++i) {
                stringBuilder.append("\n            ").append(i + 1).append(". Pel Height= ").append(group.getEntry()[i].getYPelHeight()).append("\n").append("               yMax=       ").append(group.getEntry()[i].getYMax()).append("\n").append("               yMin=       ").append(group.getEntry()[i].getYMin()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    private class Group {
        private int _recs;
        private int _startsz;
        private int _endsz;
        private VTableRecord[] _entry;

        protected Group(DataInput dataInput) throws IOException {
            this._recs = dataInput.readUnsignedShort();
            this._startsz = dataInput.readUnsignedByte();
            this._endsz = dataInput.readUnsignedByte();
            this._entry = new VTableRecord[this._recs];
            for (int i = 0; i < this._recs; ++i) {
                this._entry[i] = new VTableRecord(dataInput);
            }
        }

        public int getRecs() {
            return this._recs;
        }

        public int getStartSZ() {
            return this._startsz;
        }

        public int getEndSZ() {
            return this._endsz;
        }

        public VTableRecord[] getEntry() {
            return this._entry;
        }
    }

    private class Ratio {
        private byte _bCharSet;
        private byte _xRatio;
        private byte _yStartRatio;
        private byte _yEndRatio;

        protected Ratio(DataInput dataInput) throws IOException {
            this._bCharSet = dataInput.readByte();
            this._xRatio = dataInput.readByte();
            this._yStartRatio = dataInput.readByte();
            this._yEndRatio = dataInput.readByte();
        }

        public byte getBCharSet() {
            return this._bCharSet;
        }

        public byte getXRatio() {
            return this._xRatio;
        }

        public byte getYStartRatio() {
            return this._yStartRatio;
        }

        public byte getYEndRatio() {
            return this._yEndRatio;
        }
    }

    private class VTableRecord {
        private int _yPelHeight;
        private short _yMax;
        private short _yMin;

        protected VTableRecord(DataInput dataInput) throws IOException {
            this._yPelHeight = dataInput.readUnsignedShort();
            this._yMax = dataInput.readShort();
            this._yMin = dataInput.readShort();
        }

        public int getYPelHeight() {
            return this._yPelHeight;
        }

        public short getYMax() {
            return this._yMax;
        }

        public short getYMin() {
            return this._yMin;
        }
    }
}

