/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.locks.Lock;
import com.jogamp.newt.util.EDTUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.media.nativewindow.NativeWindowException;
import jogamp.common.util.locks.LockDebugUtil;
import jogamp.newt.Debug;

public class DefaultEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private static final Object TASK_ATTACHMENT_STOP = new Object();
    private static final Object TASK_ATTACHMENT_TEST_ERROR = new Object();
    private final Object edtLock = new Object();
    private ThreadGroup threadGroup;
    private final String name;
    private final Runnable dispatchMessages;
    private NEDT edt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;
    private static Runnable nullTask = new Runnable(){

        @Override
        public void run() {
        }
    };

    public DefaultEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.edt = new NEDT(this.threadGroup, string);
        this.edt.setDaemon(true);
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean start() throws IllegalStateException {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.edt.isRunning()) {
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + Thread.currentThread().getName() + ", EDT " + this.edt.getName() + ", isRunning " + this.edt.isRunning + ", shouldStop " + this.edt.shouldStop);
            }
            if (DEBUG) {
                if (this.edt.tasks.size() > 0) {
                    System.err.println(Thread.currentThread() + ": Default-EDT reset, remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                }
                System.err.println(Thread.currentThread() + ": Default-EDT reset - edt: " + this.edt);
            }
            if (this.edt.getState() != Thread.State.NEW) {
                if (null != this.threadGroup && this.threadGroup.isDestroyed()) {
                    this.threadGroup = Thread.currentThread().getThreadGroup();
                }
                this.edt = new NEDT(this.threadGroup, this.name);
                this.edt.setDaemon(true);
            }
            this.startImpl();
        }
        return this.invoke(true, nullTask);
    }

    private final void startImpl() {
        if (this.edt.isAlive()) {
            throw new RuntimeException("Default-EDT Thread.isAlive(): true, isRunning: " + this.edt.isRunning + ", shouldStop " + this.edt.shouldStop + ", edt: " + this.edt + ", tasks: " + this.edt.tasks.size());
        }
        ++this.start_iter;
        this.edt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": Default-EDT START - edt: " + this.edt);
        }
        this.edt.start();
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.edt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": Default-EDT.invokeStop wait " + bl);
            Thread.dumpStack();
        }
        return this.invokeImpl(bl, runnable, true, false);
    }

    public final boolean invokeAndWaitError(Runnable runnable) {
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": Default-EDT.invokeAndWaitError");
            Thread.dumpStack();
        }
        return this.invokeImpl(true, runnable, false, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2, boolean bl3) {
        Object object;
        Throwable throwable = null;
        RunnableTask runnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.edt.shouldStop) {
                    System.err.println(Thread.currentThread() + ": Warning: Default-EDT about (1) to stop, won't enqueue new task: " + this.edt);
                    if (DEBUG) {
                        Thread.dumpStack();
                    }
                    return false;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    if (bl2) {
                        this.edt.shouldStop = true;
                        if (this.edt.tasks.size() > 0) {
                            System.err.println(Thread.currentThread() + ": Warning: Default-EDT about (2) to stop, task executed. Remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                        }
                    }
                } else {
                    if (!this.edt.isRunning) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: Default-EDT is about (3) to stop and stopped already, dropping task. Remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: Default-EDT is not running, dropping task. NEDT " + this.edt);
                            }
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                        }
                        return false;
                    }
                    if (bl2 && null == runnable) {
                        runnable = nullTask;
                    }
                    if (null != runnable) {
                        ArrayList<RunnableTask> arrayList = this.edt.tasks;
                        synchronized (arrayList) {
                            runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                            if (bl2) {
                                runnableTask.setAttachment(TASK_ATTACHMENT_STOP);
                            } else if (bl3) {
                                runnableTask.setAttachment(TASK_ATTACHMENT_TEST_ERROR);
                            }
                            this.edt.tasks.add(runnableTask);
                            this.edt.tasks.notifyAll();
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = runnableTask.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
            if (DEBUG && bl2) {
                System.err.println(Thread.currentThread() + ": Default-EDT signal STOP X edt: " + this.edt);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        ArrayList<RunnableTask> arrayList = this.edtLock;
        synchronized (arrayList) {
            nEDT = this.edt;
        }
        if (!nEDT.isRunning || nEDT == Thread.currentThread()) {
            return false;
        }
        arrayList = nEDT.tasks;
        synchronized (arrayList) {
            while (nEDT.isRunning && nEDT.tasks.size() > 0) {
                try {
                    nEDT.tasks.notifyAll();
                    nEDT.tasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.edt.isRunning && this.edt != Thread.currentThread()) {
                while (this.edt.isRunning) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        final ArrayList<RunnableTask> tasks;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.tasks = new ArrayList();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        private final void validateNoRecursiveLocksHold() {
            if (LockDebugUtil.getRecursiveLockTrace().size() > 0) {
                LockDebugUtil.dumpRecursiveLockTrace((PrintStream)System.err);
                throw new InternalError("XXX");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            Object object2;
            RuntimeException runtimeException;
            block38: {
                if (DEBUG) {
                    System.err.println(this.getName() + ": Default-EDT run() START " + this.getName());
                }
                if (Lock.DEBUG) {
                    this.validateNoRecursiveLocksHold();
                }
                runtimeException = null;
                try {
                    do {
                        if (!this.shouldStop) {
                            DefaultEDTUtil.this.dispatchMessages.run();
                        }
                        object2 = null;
                        object = this.tasks;
                        synchronized (object) {
                            if (!this.shouldStop && this.tasks.size() == 0) {
                                try {
                                    this.tasks.wait(pollPeriod);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            if (this.tasks.size() > 0) {
                                object2 = this.tasks.remove(0);
                                this.tasks.notifyAll();
                                Object object3 = object2.getAttachment();
                                if (TASK_ATTACHMENT_STOP == object3) {
                                    this.shouldStop = true;
                                } else if (TASK_ATTACHMENT_TEST_ERROR == object3) {
                                    this.tasks.add(0, (RunnableTask)object2);
                                    object2 = null;
                                    throw new RuntimeException("TASK_ATTACHMENT_TEST_ERROR");
                                }
                            }
                        }
                        if (null == object2) continue;
                        object2.run();
                        if (Lock.DEBUG) {
                            this.validateNoRecursiveLocksHold();
                        }
                        if (object2.hasWaiter() || null == object2.getThrowable()) continue;
                        System.err.println("DefaultEDT.run(): Catched exception occured on thread " + Thread.currentThread().getName() + ": " + object2.toString());
                        object2.getThrowable().printStackTrace();
                    } while (!this.shouldStop);
                    object2 = this.getName() + ": Default-EDT finished w/ " + this.tasks.size() + " left";
                    if (!DEBUG) break block38;
                    System.err.println((String)object2 + ", " + runtimeException);
                }
                catch (Throwable throwable) {
                    String string;
                    block39: {
                        try {
                            this.shouldStop = true;
                            runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Within Default-EDT", throwable);
                            string = this.getName() + ": Default-EDT finished w/ " + this.tasks.size() + " left";
                            if (!DEBUG) break block39;
                            System.err.println(string + ", " + runtimeException);
                        }
                        catch (Throwable throwable2) {
                            String string2 = this.getName() + ": Default-EDT finished w/ " + this.tasks.size() + " left";
                            if (DEBUG) {
                                System.err.println(string2 + ", " + runtimeException);
                            }
                            Object object4 = DefaultEDTUtil.this.edtLock;
                            synchronized (object4) {
                                int n = 0;
                                while (this.tasks.size() > 0) {
                                    Throwable throwable3;
                                    String string3 = string2 + ", task #" + n;
                                    Throwable throwable4 = throwable3 = null != runtimeException ? new Throwable(string3, runtimeException) : new Throwable(string3);
                                    RunnableTask runnableTask = this.tasks.remove(0);
                                    if (null == runnableTask) continue;
                                    runnableTask.flush(throwable3);
                                    ++n;
                                }
                                this.isRunning = false;
                                DefaultEDTUtil.this.edtLock.notifyAll();
                            }
                            if (DEBUG) {
                                System.err.println(string2 + " EXIT, exception: " + runtimeException);
                            }
                            if (null != runtimeException) {
                                throw runtimeException;
                            }
                            throw throwable2;
                        }
                    }
                    Object object5 = DefaultEDTUtil.this.edtLock;
                    synchronized (object5) {
                        int n = 0;
                        while (this.tasks.size() > 0) {
                            Throwable throwable5;
                            String string4 = string + ", task #" + n;
                            Throwable throwable6 = throwable5 = null != runtimeException ? new Throwable(string4, runtimeException) : new Throwable(string4);
                            RunnableTask runnableTask = this.tasks.remove(0);
                            if (null == runnableTask) continue;
                            runnableTask.flush(throwable5);
                            ++n;
                        }
                        this.isRunning = false;
                        DefaultEDTUtil.this.edtLock.notifyAll();
                    }
                    if (DEBUG) {
                        System.err.println(string + " EXIT, exception: " + runtimeException);
                    }
                    if (null != runtimeException) {
                        throw runtimeException;
                    }
                }
            }
            object = DefaultEDTUtil.this.edtLock;
            synchronized (object) {
                int n = 0;
                while (this.tasks.size() > 0) {
                    Throwable throwable;
                    String string = (String)object2 + ", task #" + n;
                    Throwable throwable7 = throwable = null != runtimeException ? new Throwable(string, runtimeException) : new Throwable(string);
                    RunnableTask runnableTask = this.tasks.remove(0);
                    if (null == runnableTask) continue;
                    runnableTask.flush(throwable);
                    ++n;
                }
                this.isRunning = false;
                DefaultEDTUtil.this.edtLock.notifyAll();
            }
            if (DEBUG) {
                System.err.println((String)object2 + " EXIT, exception: " + runtimeException);
            }
            if (null != runtimeException) {
                throw runtimeException;
            }
        }
    }
}

