/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context context, Class<?> clazz, ScriptableObject scriptableObject) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable scriptable = ScriptRuntime.getTopCallScope(context);
        ClassCache classCache = ClassCache.get(scriptable);
        InterfaceAdapter interfaceAdapter = (InterfaceAdapter)classCache.getInterfaceAdapter(clazz);
        ContextFactory contextFactory = context.getFactory();
        if (interfaceAdapter == null) {
            Method[] methodArray = clazz.getMethods();
            if (scriptableObject instanceof Callable) {
                int n = methodArray.length;
                if (n == 0) {
                    throw Context.reportRuntimeError1("msg.no.empty.interface.conversion", clazz.getName());
                }
                if (n > 1) {
                    String string = methodArray[0].getName();
                    for (int i = 1; i < n; ++i) {
                        if (string.equals(methodArray[i].getName())) continue;
                        throw Context.reportRuntimeError1("msg.no.function.interface.conversion", clazz.getName());
                    }
                }
            }
            interfaceAdapter = new InterfaceAdapter(contextFactory, clazz);
            classCache.cacheInterfaceAdapter(clazz, interfaceAdapter);
        }
        return VMBridge.instance.newInterfaceProxy(interfaceAdapter.proxyHelper, contextFactory, interfaceAdapter, scriptableObject, scriptable);
    }

    private InterfaceAdapter(ContextFactory contextFactory, Class<?> clazz) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(contextFactory, new Class[]{clazz});
    }

    public Object invoke(ContextFactory contextFactory, final Object object, final Scriptable scriptable, final Object object2, final Method method, final Object[] objectArray) {
        ContextAction contextAction = new ContextAction(){

            @Override
            public Object run(Context context) {
                return InterfaceAdapter.this.invokeImpl(context, object, scriptable, object2, method, objectArray);
            }
        };
        return contextFactory.call(contextAction);
    }

    Object invokeImpl(Context context, Object object, Scriptable scriptable, Object object2, Method method, Object[] objectArray) {
        Class<?> clazz;
        Object object3;
        Object object4;
        Object object5;
        Callable callable;
        if (object instanceof Callable) {
            callable = (Callable)object;
        } else {
            object5 = (Scriptable)object;
            object4 = method.getName();
            object3 = ScriptableObject.getProperty((Scriptable)object5, (String)object4);
            if (object3 == ScriptableObject.NOT_FOUND) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.undefined.function.interface", object4));
                Class<?> clazz2 = method.getReturnType();
                if (clazz2 == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava(null, clazz2);
            }
            if (!(object3 instanceof Callable)) {
                throw Context.reportRuntimeError1("msg.not.function.interface", object4);
            }
            callable = (Callable)object3;
        }
        object5 = context.getWrapFactory();
        if (objectArray == null) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            int n = objectArray.length;
            for (int i = 0; i != n; ++i) {
                clazz = objectArray[i];
                if (clazz instanceof String || clazz instanceof Number || clazz instanceof Boolean) continue;
                objectArray[i] = ((WrapFactory)object5).wrap(context, scriptable, clazz, null);
            }
        }
        object4 = ((WrapFactory)object5).wrapAsJavaObject(context, scriptable, object2, null);
        object3 = callable.call(context, scriptable, (Scriptable)object4, objectArray);
        clazz = method.getReturnType();
        object3 = clazz == Void.TYPE ? null : Context.jsToJava(object3, clazz);
        return object3;
    }
}

