/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.Collator;
import java.text.Normalizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;

final class NativeString
extends IdScriptableObject {
    static final long serialVersionUID = 920268368584188687L;
    private static final Object STRING_TAG = "String";
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int Id_localeCompare = 34;
    private static final int Id_toLocaleLowerCase = 35;
    private static final int Id_toLocaleUpperCase = 36;
    private static final int Id_trim = 37;
    private static final int Id_trimLeft = 38;
    private static final int Id_trimRight = 39;
    private static final int Id_includes = 40;
    private static final int Id_startsWith = 41;
    private static final int Id_endsWith = 42;
    private static final int Id_normalize = 43;
    private static final int Id_repeat = 44;
    private static final int Id_codePointAt = 45;
    private static final int MAX_PROTOTYPE_ID = 45;
    private static final int ConstructorId_charAt = -5;
    private static final int ConstructorId_charCodeAt = -6;
    private static final int ConstructorId_indexOf = -7;
    private static final int ConstructorId_lastIndexOf = -8;
    private static final int ConstructorId_split = -9;
    private static final int ConstructorId_substring = -10;
    private static final int ConstructorId_toLowerCase = -11;
    private static final int ConstructorId_toUpperCase = -12;
    private static final int ConstructorId_substr = -13;
    private static final int ConstructorId_concat = -14;
    private static final int ConstructorId_slice = -15;
    private static final int ConstructorId_equalsIgnoreCase = -30;
    private static final int ConstructorId_match = -31;
    private static final int ConstructorId_search = -32;
    private static final int ConstructorId_replace = -33;
    private static final int ConstructorId_localeCompare = -34;
    private static final int ConstructorId_toLocaleLowerCase = -35;
    private CharSequence string;

    static void init(Scriptable scriptable, boolean bl) {
        NativeString nativeString = new NativeString("");
        nativeString.exportAsJSClass(45, scriptable, bl);
    }

    NativeString(CharSequence charSequence) {
        this.string = charSequence;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeString.instanceIdInfo(7, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.string.length());
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -1, "fromCharCode", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -5, "charAt", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -6, "charCodeAt", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -7, "indexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -8, "lastIndexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -9, "split", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -10, "substring", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -11, "toLowerCase", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -12, "toUpperCase", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -13, "substr", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -14, "concat", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -15, "slice", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -30, "equalsIgnoreCase", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -31, "match", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -32, "search", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -33, "replace", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -34, "localeCompare", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -35, "toLocaleLowerCase", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "charAt";
                break;
            }
            case 6: {
                n2 = 1;
                string = "charCodeAt";
                break;
            }
            case 7: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 8: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 9: {
                n2 = 2;
                string = "split";
                break;
            }
            case 10: {
                n2 = 2;
                string = "substring";
                break;
            }
            case 11: {
                n2 = 0;
                string = "toLowerCase";
                break;
            }
            case 12: {
                n2 = 0;
                string = "toUpperCase";
                break;
            }
            case 13: {
                n2 = 2;
                string = "substr";
                break;
            }
            case 14: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 15: {
                n2 = 2;
                string = "slice";
                break;
            }
            case 16: {
                n2 = 0;
                string = "bold";
                break;
            }
            case 17: {
                n2 = 0;
                string = "italics";
                break;
            }
            case 18: {
                n2 = 0;
                string = "fixed";
                break;
            }
            case 19: {
                n2 = 0;
                string = "strike";
                break;
            }
            case 20: {
                n2 = 0;
                string = "small";
                break;
            }
            case 21: {
                n2 = 0;
                string = "big";
                break;
            }
            case 22: {
                n2 = 0;
                string = "blink";
                break;
            }
            case 23: {
                n2 = 0;
                string = "sup";
                break;
            }
            case 24: {
                n2 = 0;
                string = "sub";
                break;
            }
            case 25: {
                n2 = 0;
                string = "fontsize";
                break;
            }
            case 26: {
                n2 = 0;
                string = "fontcolor";
                break;
            }
            case 27: {
                n2 = 0;
                string = "link";
                break;
            }
            case 28: {
                n2 = 0;
                string = "anchor";
                break;
            }
            case 29: {
                n2 = 1;
                string = "equals";
                break;
            }
            case 30: {
                n2 = 1;
                string = "equalsIgnoreCase";
                break;
            }
            case 31: {
                n2 = 1;
                string = "match";
                break;
            }
            case 32: {
                n2 = 1;
                string = "search";
                break;
            }
            case 33: {
                n2 = 2;
                string = "replace";
                break;
            }
            case 34: {
                n2 = 1;
                string = "localeCompare";
                break;
            }
            case 35: {
                n2 = 0;
                string = "toLocaleLowerCase";
                break;
            }
            case 36: {
                n2 = 0;
                string = "toLocaleUpperCase";
                break;
            }
            case 37: {
                n2 = 0;
                string = "trim";
                break;
            }
            case 38: {
                n2 = 0;
                string = "trimLeft";
                break;
            }
            case 39: {
                n2 = 0;
                string = "trimRight";
                break;
            }
            case 40: {
                n2 = 1;
                string = "includes";
                break;
            }
            case 41: {
                n2 = 1;
                string = "startsWith";
                break;
            }
            case 42: {
                n2 = 1;
                string = "endsWith";
                break;
            }
            case 43: {
                n2 = 0;
                string = "normalize";
                break;
            }
            case 44: {
                n2 = 1;
                string = "repeat";
                break;
            }
            case 45: {
                n2 = 1;
                string = "codePointAt";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(STRING_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(STRING_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        block42: while (true) {
            switch (n) {
                case -35: 
                case -34: 
                case -33: 
                case -32: 
                case -31: 
                case -30: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    Object[] objectArray2;
                    if (objectArray.length > 0) {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, ScriptRuntime.toCharSequence(objectArray[0]));
                        objectArray2 = new Object[objectArray.length - 1];
                        for (int i = 0; i < objectArray2.length; ++i) {
                            objectArray2[i] = objectArray[i + 1];
                        }
                        objectArray = objectArray2;
                    } else {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, ScriptRuntime.toCharSequence(scriptable2));
                    }
                    n = -n;
                    continue block42;
                }
                case -1: {
                    int n2 = objectArray.length;
                    if (n2 < 1) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder(n2);
                    for (int i = 0; i != n2; ++i) {
                        stringBuilder.append(ScriptRuntime.toUint16(objectArray[i]));
                    }
                    return stringBuilder.toString();
                }
                case 1: {
                    Object[] objectArray2;
                    Object[] objectArray3 = objectArray2 = objectArray.length >= 1 ? ScriptRuntime.toCharSequence(objectArray[0]) : "";
                    if (scriptable2 == null) {
                        return new NativeString((CharSequence)objectArray2);
                    }
                    return objectArray2 instanceof String ? objectArray2 : objectArray2.toString();
                }
                case 2: 
                case 4: {
                    Object[] objectArray2 = NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
                    return objectArray2 instanceof String ? objectArray2 : objectArray2.toString();
                }
                case 3: {
                    CharSequence charSequence = NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
                    return "(new String(\"" + ScriptRuntime.escapeString(charSequence.toString()) + "\"))";
                }
                case 5: 
                case 6: {
                    CharSequence charSequence = ScriptRuntime.toCharSequence(scriptable2);
                    double d = ScriptRuntime.toInteger(objectArray, 0);
                    if (d < 0.0 || d >= (double)charSequence.length()) {
                        if (n == 5) {
                            return "";
                        }
                        return ScriptRuntime.NaNobj;
                    }
                    char c = charSequence.charAt((int)d);
                    if (n == 5) {
                        return String.valueOf(c);
                    }
                    return ScriptRuntime.wrapInt(c);
                }
                case 7: {
                    return ScriptRuntime.wrapInt(NativeString.js_indexOf(7, ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 40: 
                case 41: 
                case 42: {
                    String string = ScriptRuntime.toString(ScriptRuntime.requireObjectCoercible(scriptable2, idFunctionObject));
                    if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
                        throw ScriptRuntime.typeError2("msg.first.arg.not.regexp", String.class.getSimpleName(), idFunctionObject.getFunctionName());
                    }
                    int n3 = NativeString.js_indexOf(n, string, objectArray);
                    if (n == 40) {
                        return n3 != -1;
                    }
                    if (n == 41) {
                        return n3 == 0;
                    }
                    if (n == 42) {
                        return n3 != -1;
                    }
                }
                case 8: {
                    return ScriptRuntime.wrapInt(NativeString.js_lastIndexOf(ScriptRuntime.toString(scriptable2), objectArray));
                }
                case 9: {
                    return ScriptRuntime.checkRegExpProxy(context).js_split(context, scriptable, ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 10: {
                    return NativeString.js_substring(context, ScriptRuntime.toCharSequence(scriptable2), objectArray);
                }
                case 11: {
                    return ScriptRuntime.toString(scriptable2).toLowerCase(ScriptRuntime.ROOT_LOCALE);
                }
                case 12: {
                    return ScriptRuntime.toString(scriptable2).toUpperCase(ScriptRuntime.ROOT_LOCALE);
                }
                case 13: {
                    return NativeString.js_substr(ScriptRuntime.toCharSequence(scriptable2), objectArray);
                }
                case 14: {
                    return NativeString.js_concat(ScriptRuntime.toString(scriptable2), objectArray);
                }
                case 15: {
                    return NativeString.js_slice(ScriptRuntime.toCharSequence(scriptable2), objectArray);
                }
                case 16: {
                    return NativeString.tagify(scriptable2, "b", null, null);
                }
                case 17: {
                    return NativeString.tagify(scriptable2, "i", null, null);
                }
                case 18: {
                    return NativeString.tagify(scriptable2, "tt", null, null);
                }
                case 19: {
                    return NativeString.tagify(scriptable2, "strike", null, null);
                }
                case 20: {
                    return NativeString.tagify(scriptable2, "small", null, null);
                }
                case 21: {
                    return NativeString.tagify(scriptable2, "big", null, null);
                }
                case 22: {
                    return NativeString.tagify(scriptable2, "blink", null, null);
                }
                case 23: {
                    return NativeString.tagify(scriptable2, "sup", null, null);
                }
                case 24: {
                    return NativeString.tagify(scriptable2, "sub", null, null);
                }
                case 25: {
                    return NativeString.tagify(scriptable2, "font", "size", objectArray);
                }
                case 26: {
                    return NativeString.tagify(scriptable2, "font", "color", objectArray);
                }
                case 27: {
                    return NativeString.tagify(scriptable2, "a", "href", objectArray);
                }
                case 28: {
                    return NativeString.tagify(scriptable2, "a", "name", objectArray);
                }
                case 29: 
                case 30: {
                    String string = ScriptRuntime.toString(scriptable2);
                    String string2 = ScriptRuntime.toString(objectArray, 0);
                    return ScriptRuntime.wrapBoolean(n == 29 ? string.equals(string2) : string.equalsIgnoreCase(string2));
                }
                case 31: 
                case 32: 
                case 33: {
                    int n4 = n == 31 ? 1 : (n == 32 ? 3 : 2);
                    return ScriptRuntime.checkRegExpProxy(context).action(context, scriptable, scriptable2, objectArray, n4);
                }
                case 34: {
                    Collator collator = Collator.getInstance(context.getLocale());
                    collator.setStrength(3);
                    collator.setDecomposition(1);
                    return ScriptRuntime.wrapNumber(collator.compare(ScriptRuntime.toString(scriptable2), ScriptRuntime.toString(objectArray, 0)));
                }
                case 35: {
                    return ScriptRuntime.toString(scriptable2).toLowerCase(context.getLocale());
                }
                case 36: {
                    return ScriptRuntime.toString(scriptable2).toUpperCase(context.getLocale());
                }
                case 37: {
                    int n5;
                    int n6;
                    String string = ScriptRuntime.toString(scriptable2);
                    char[] cArray = string.toCharArray();
                    for (n6 = 0; n6 < cArray.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n6]); ++n6) {
                    }
                    for (n5 = cArray.length; n5 > n6 && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n5 - 1]); --n5) {
                    }
                    return string.substring(n6, n5);
                }
                case 38: {
                    int n7;
                    String string = ScriptRuntime.toString(scriptable2);
                    char[] cArray = string.toCharArray();
                    for (n7 = 0; n7 < cArray.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n7]); ++n7) {
                    }
                    int n8 = cArray.length;
                    return string.substring(n7, n8);
                }
                case 39: {
                    int n9;
                    String string = ScriptRuntime.toString(scriptable2);
                    char[] cArray = string.toCharArray();
                    int n10 = 0;
                    for (n9 = cArray.length; n9 > n10 && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n9 - 1]); --n9) {
                    }
                    return string.substring(n10, n9);
                }
                case 43: {
                    Normalizer.Form form;
                    String string = ScriptRuntime.toString(objectArray, 0);
                    if (Normalizer.Form.NFD.name().equals(string)) {
                        form = Normalizer.Form.NFD;
                    } else if (Normalizer.Form.NFKC.name().equals(string)) {
                        form = Normalizer.Form.NFKC;
                    } else if (Normalizer.Form.NFKD.name().equals(string)) {
                        form = Normalizer.Form.NFKD;
                    } else if (Normalizer.Form.NFC.name().equals(string) || objectArray.length == 0) {
                        form = Normalizer.Form.NFC;
                    } else {
                        throw ScriptRuntime.rangeError("The normalization form should be one of NFC, NFD, NFKC, NFKD");
                    }
                    return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntime.requireObjectCoercible(scriptable2, idFunctionObject)), form);
                }
                case 44: {
                    String string = ScriptRuntime.toString(ScriptRuntime.requireObjectCoercible(scriptable2, idFunctionObject));
                    double d = ScriptRuntime.toInteger(objectArray, 0);
                    if (d == 0.0) {
                        return "";
                    }
                    if (d < 0.0 || d == Double.POSITIVE_INFINITY) {
                        throw ScriptRuntime.rangeError("Invalid count value");
                    }
                    long l = (long)string.length() * (long)d;
                    if (d >= 2.147483647E9 || l >= Integer.MAX_VALUE) {
                        l = Integer.MAX_VALUE;
                    }
                    StringBuilder stringBuilder = new StringBuilder((int)l);
                    stringBuilder.append(string);
                    int n11 = 1;
                    while ((double)n11 <= d / 2.0) {
                        stringBuilder.append((CharSequence)stringBuilder);
                        n11 *= 2;
                    }
                    while (true) {
                        int n12 = n11++;
                        if (!((double)n12 < d)) break;
                        stringBuilder.append(string);
                    }
                    return stringBuilder.toString();
                }
                case 45: {
                    String string = ScriptRuntime.toString(ScriptRuntime.requireObjectCoercible(scriptable2, idFunctionObject));
                    double d = ScriptRuntime.toInteger(objectArray, 0);
                    return d < 0.0 || d >= (double)string.length() ? Undefined.instance : Integer.valueOf(string.codePointAt((int)d));
                }
            }
            break;
        }
        throw new IllegalArgumentException("String.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private static NativeString realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeString)) {
            throw NativeString.incompatibleCallError(idFunctionObject);
        }
        return (NativeString)scriptable;
    }

    private static String tagify(Object object, String string, String string2, Object[] objectArray) {
        String string3 = ScriptRuntime.toString(object);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string2);
            stringBuilder.append("=\"");
            stringBuilder.append(ScriptRuntime.toString(objectArray, 0));
            stringBuilder.append('\"');
        }
        stringBuilder.append('>');
        stringBuilder.append(string3);
        stringBuilder.append("</");
        stringBuilder.append(string);
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public CharSequence toCharSequence() {
        return this.string;
    }

    public String toString() {
        return this.string instanceof String ? (String)this.string : this.string.toString();
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (0 <= n && n < this.string.length()) {
            return String.valueOf(this.string.charAt(n));
        }
        return super.get(n, scriptable);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    private static int js_indexOf(int n, String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toInteger(objectArray, 1);
        if (d > (double)string.length() && n != 41 && n != 42) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        } else if (d > (double)string.length()) {
            d = string.length();
        } else if (n == 42 && (d != d || d > (double)string.length())) {
            d = string.length();
        }
        if (42 == n) {
            if (objectArray.length == 0 || objectArray.length == 1 || objectArray.length == 2 && objectArray[1] == Undefined.instance) {
                d = string.length();
            }
            return string.substring(0, (int)d).endsWith(string2) ? 0 : -1;
        }
        return n == 41 ? (string.startsWith(string2, (int)d) ? 0 : -1) : string.indexOf(string2, (int)d);
    }

    private static int js_lastIndexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toNumber(objectArray, 1);
        if (d != d || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    private static CharSequence js_substring(Context context, CharSequence charSequence, Object[] objectArray) {
        double d;
        int n = charSequence.length();
        double d2 = ScriptRuntime.toInteger(objectArray, 0);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length <= 1 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return charSequence.subSequence((int)d2, (int)d);
    }

    int getLength() {
        return this.string.length();
    }

    private static CharSequence js_substr(CharSequence charSequence, Object[] objectArray) {
        double d;
        if (objectArray.length < 1) {
            return charSequence;
        }
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        int n = charSequence.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += d2) > (double)n) {
                d = n;
            }
        }
        return charSequence.subSequence((int)d2, (int)d);
    }

    private static String js_concat(String string, Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            String string2 = ScriptRuntime.toString(objectArray[0]);
            return string.concat(string2);
        }
        int n2 = string.length();
        String[] stringArray = new String[n];
        for (int i = 0; i != n; ++i) {
            String string3;
            stringArray[i] = string3 = ScriptRuntime.toString(objectArray[i]);
            n2 += string3.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string);
        for (int i = 0; i != n; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static CharSequence js_slice(CharSequence charSequence, Object[] objectArray) {
        double d;
        double d2 = objectArray.length < 1 ? 0.0 : ScriptRuntime.toInteger(objectArray[0]);
        int n = charSequence.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length < 2 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                if ((d += (double)n) < 0.0) {
                    d = 0.0;
                }
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                d = d2;
            }
        }
        return charSequence.subSequence((int)d2, (int)d);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(2);
                if (c == 'b') {
                    if (string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                    return 24;
                }
                if (c == 'g') {
                    if (string.charAt(0) != 'b' || string.charAt(1) != 'i') break;
                    return 21;
                }
                if (c != 'p' || string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'b') {
                    string2 = "bold";
                    n = 16;
                    break;
                }
                if (c == 'l') {
                    string2 = "link";
                    n = 27;
                    break;
                }
                if (c != 't') break;
                string2 = "trim";
                n = 37;
                break;
            }
            case 5: {
                switch (string.charAt(4)) {
                    case 'd': {
                        string2 = "fixed";
                        n = 18;
                        break block0;
                    }
                    case 'e': {
                        string2 = "slice";
                        n = 15;
                        break block0;
                    }
                    case 'h': {
                        string2 = "match";
                        n = 31;
                        break block0;
                    }
                    case 'k': {
                        string2 = "blink";
                        n = 22;
                        break block0;
                    }
                    case 'l': {
                        string2 = "small";
                        n = 20;
                        break block0;
                    }
                    case 't': {
                        string2 = "split";
                        n = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(1)) {
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'r') {
                            string2 = "repeat";
                            n = 44;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "search";
                        n = 32;
                        break;
                    }
                    case 'h': {
                        string2 = "charAt";
                        n = 5;
                        break;
                    }
                    case 'n': {
                        string2 = "anchor";
                        n = 28;
                        break;
                    }
                    case 'o': {
                        string2 = "concat";
                        n = 14;
                        break;
                    }
                    case 'q': {
                        string2 = "equals";
                        n = 29;
                        break;
                    }
                    case 't': {
                        string2 = "strike";
                        n = 19;
                        break;
                    }
                    case 'u': {
                        string2 = "substr";
                        n = 13;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(1)) {
                    case 'a': {
                        string2 = "valueOf";
                        n = 4;
                        break block0;
                    }
                    case 'e': {
                        string2 = "replace";
                        n = 33;
                        break block0;
                    }
                    case 'n': {
                        string2 = "indexOf";
                        n = 7;
                        break block0;
                    }
                    case 't': {
                        string2 = "italics";
                        n = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(6)) {
                    case 'c': {
                        string2 = "toSource";
                        n = 3;
                        break block0;
                    }
                    case 'e': {
                        string2 = "includes";
                        n = 40;
                        break block0;
                    }
                    case 'f': {
                        string2 = "trimLeft";
                        n = 38;
                        break block0;
                    }
                    case 'n': {
                        string2 = "toString";
                        n = 2;
                        break block0;
                    }
                    case 't': {
                        string2 = "endsWith";
                        n = 42;
                        break block0;
                    }
                    case 'z': {
                        string2 = "fontsize";
                        n = 25;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (string.charAt(0)) {
                    case 'f': {
                        string2 = "fontcolor";
                        n = 26;
                        break block0;
                    }
                    case 'n': {
                        string2 = "normalize";
                        n = 43;
                        break block0;
                    }
                    case 's': {
                        string2 = "substring";
                        n = 10;
                        break block0;
                    }
                    case 't': {
                        string2 = "trimRight";
                        n = 39;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "charCodeAt";
                    n = 6;
                    break;
                }
                if (c != 's') break;
                string2 = "startsWith";
                n = 41;
                break;
            }
            case 11: {
                switch (string.charAt(2)) {
                    case 'L': {
                        string2 = "toLowerCase";
                        n = 11;
                        break block0;
                    }
                    case 'U': {
                        string2 = "toUpperCase";
                        n = 12;
                        break block0;
                    }
                    case 'd': {
                        string2 = "codePointAt";
                        n = 45;
                        break block0;
                    }
                    case 'n': {
                        string2 = "constructor";
                        n = 1;
                        break block0;
                    }
                    case 's': {
                        string2 = "lastIndexOf";
                        n = 8;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                string2 = "localeCompare";
                n = 34;
                break;
            }
            case 16: {
                string2 = "equalsIgnoreCase";
                n = 30;
                break;
            }
            case 17: {
                char c = string.charAt(8);
                if (c == 'L') {
                    string2 = "toLocaleLowerCase";
                    n = 35;
                    break;
                }
                if (c != 'U') break;
                string2 = "toLocaleUpperCase";
                n = 36;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

