/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

class DiyFp {
    private long f;
    private int e;
    static final int kSignificandSize = 64;
    static final long kUint64MSB = Long.MIN_VALUE;

    DiyFp() {
        this.f = 0L;
        this.e = 0;
    }

    DiyFp(long l, int n) {
        this.f = l;
        this.e = n;
    }

    private static boolean uint64_gte(long l, long l2) {
        return l == l2 || l > l2 ^ l < 0L ^ l2 < 0L;
    }

    void subtract(DiyFp diyFp) {
        assert (this.e == diyFp.e);
        assert (DiyFp.uint64_gte(this.f, diyFp.f));
        this.f -= diyFp.f;
    }

    static DiyFp minus(DiyFp diyFp, DiyFp diyFp2) {
        DiyFp diyFp3 = new DiyFp(diyFp.f, diyFp.e);
        diyFp3.subtract(diyFp2);
        return diyFp3;
    }

    void multiply(DiyFp diyFp) {
        long l = 0xFFFFFFFFL;
        long l2 = this.f >>> 32;
        long l3 = this.f & 0xFFFFFFFFL;
        long l4 = diyFp.f >>> 32;
        long l5 = diyFp.f & 0xFFFFFFFFL;
        long l6 = l2 * l4;
        long l7 = l3 * l4;
        long l8 = l2 * l5;
        long l9 = l3 * l5;
        long l10 = (l9 >>> 32) + (l8 & 0xFFFFFFFFL) + (l7 & 0xFFFFFFFFL);
        long l11 = l6 + (l8 >>> 32) + (l7 >>> 32) + ((l10 += 0x80000000L) >>> 32);
        this.e += diyFp.e + 64;
        this.f = l11;
    }

    static DiyFp times(DiyFp diyFp, DiyFp diyFp2) {
        DiyFp diyFp3 = new DiyFp(diyFp.f, diyFp.e);
        diyFp3.multiply(diyFp2);
        return diyFp3;
    }

    void normalize() {
        assert (this.f != 0L);
        long l = this.f;
        int n = this.e;
        long l2 = -18014398509481984L;
        while ((l & 0xFFC0000000000000L) == 0L) {
            l <<= 10;
            n -= 10;
        }
        while ((l & Long.MIN_VALUE) == 0L) {
            l <<= 1;
            --n;
        }
        this.f = l;
        this.e = n;
    }

    static DiyFp normalize(DiyFp diyFp) {
        DiyFp diyFp2 = new DiyFp(diyFp.f, diyFp.e);
        diyFp2.normalize();
        return diyFp2;
    }

    long f() {
        return this.f;
    }

    int e() {
        return this.e;
    }

    void setF(long l) {
        this.f = l;
    }

    void setE(int n) {
        this.e = n;
    }

    public String toString() {
        return "[DiyFp f:" + this.f + ", e:" + this.e + "]";
    }
}

