/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.util.LongObjectHashMap;

abstract class DynamicLinkerImpl
implements DynamicLinker {
    private final LongObjectHashMap libHandle2Name = new LongObjectHashMap(16);

    DynamicLinkerImpl() {
    }

    protected final synchronized LibRef getLibRef(long l) {
        return (LibRef)this.libHandle2Name.get(l);
    }

    protected final synchronized LibRef incrLibRefCount(long l, String string) {
        LibRef libRef = this.getLibRef(l);
        if (null == libRef) {
            libRef = new LibRef(string);
            this.libHandle2Name.put(l, libRef);
        } else {
            libRef.incrRefCount();
        }
        if (DEBUG) {
            System.err.println("DynamicLinkerImpl.incrLibRefCount 0x" + Long.toHexString(l) + " -> " + libRef + ", libs loaded " + this.libHandle2Name.size());
        }
        return libRef;
    }

    protected final synchronized LibRef decrLibRefCount(long l) {
        LibRef libRef = this.getLibRef(l);
        if (null != libRef && 0 == libRef.decrRefCount()) {
            this.libHandle2Name.remove(l);
        }
        if (DEBUG) {
            System.err.println("DynamicLinkerImpl.decrLibRefCount 0x" + Long.toHexString(l) + " -> " + libRef + ", libs loaded " + this.libHandle2Name.size());
        }
        return libRef;
    }

    protected static final class LibRef {
        private final String name;
        private int refCount;

        public LibRef(String string) {
            this.name = string;
            this.refCount = 1;
        }

        public final int incrRefCount() {
            return ++this.refCount;
        }

        public final int decrRefCount() {
            return --this.refCount;
        }

        public final int getRefCount() {
            return this.refCount;
        }

        public final String getName() {
            return this.name;
        }

        public final String toString() {
            return "LibRef[" + this.name + ", refCount " + this.refCount + "]";
        }
    }
}

