/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty.internal;

import org.gradle.api.plugins.jetty.internal.JettyPluginServer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty6PluginServer
implements JettyPluginServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jetty6PluginServer.class);
    public static final int DEFAULT_MAX_IDLE_TIME = 30000;
    private Server server = new Server();
    private ContextHandlerCollection contexts;
    HandlerCollection handlers;
    private RequestLogHandler requestLogHandler;
    private DefaultHandler defaultHandler;
    private RequestLog requestLog;

    public Jetty6PluginServer() {
        this.server.setStopAtShutdown(true);
        Resource.setDefaultUseCaches((boolean)false);
    }

    public void setConnectors(Object[] connectors) {
        if (connectors == null || connectors.length == 0) {
            return;
        }
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = (Connector)connectors[i];
            LOGGER.debug("Setting Connector: {} on port {}", (Object)connector.getClass().getName(), (Object)connector.getPort());
            this.server.addConnector(connector);
        }
    }

    public Object[] getConnectors() {
        return this.server.getConnectors();
    }

    public void setUserRealms(Object[] realms) throws Exception {
        if (realms == null) {
            return;
        }
        for (int i = 0; i < realms.length; ++i) {
            this.server.addUserRealm((UserRealm)realms[i]);
        }
    }

    public Object[] getUserRealms() {
        return this.server.getUserRealms();
    }

    public void setRequestLog(Object requestLog) {
        this.requestLog = (RequestLog)requestLog;
    }

    public Object getRequestLog() {
        return this.requestLog;
    }

    public void start() throws Exception {
        LOGGER.info("Starting jetty {} ...", (Object)this.server.getClass().getPackage().getImplementationVersion());
        this.server.start();
    }

    public Object getProxiedObject() {
        return this.server;
    }

    public void addWebApplication(WebAppContext webapp) throws Exception {
        this.contexts.addHandler((Handler)webapp);
    }

    public void configureHandlers() throws Exception {
        this.defaultHandler = new DefaultHandler();
        this.requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            this.requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            this.handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
            if (this.handlers == null) {
                this.handlers = new HandlerCollection();
                this.server.setHandler((Handler)this.handlers);
                this.handlers.setHandlers(new Handler[]{this.contexts, this.defaultHandler, this.requestLogHandler});
            } else {
                this.handlers.addHandler((Handler)this.contexts);
            }
        }
    }

    public Object createDefaultConnector(int port) throws Exception {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        connector.setMaxIdleTime(30000);
        return connector;
    }

    public void join() throws Exception {
        this.server.getThreadPool().join();
    }
}

