/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;

public class DefaultModuleIdentifier
implements ModuleIdentifier {
    private final String group;
    private final String name;

    public DefaultModuleIdentifier(String group, String name) {
        assert (group != null) : "group cannot be null";
        assert (name != null) : "name cannot be null";
        this.group = group;
        this.name = name;
    }

    public static ModuleIdentifier newId(String group, String name) {
        return new DefaultModuleIdentifier(group, name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleIdentifier other = (DefaultModuleIdentifier)obj;
        if (!this.group.equals(other.group)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.group.hashCode() ^ this.name.hashCode();
    }
}

