/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CompositeConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConflictHandler
implements ConflictHandler {
    private static final Logger LOGGER = Logging.getLogger(DefaultConflictHandler.class);
    private final CompositeConflictResolver compositeResolver = new CompositeConflictResolver();
    private final ConflictContainer<ModuleIdentifier, ComponentResolutionState> conflicts = new ConflictContainer();
    private final ModuleReplacementsData moduleReplacements;

    public DefaultConflictHandler(ModuleConflictResolver conflictResolver, ModuleReplacementsData moduleReplacements) {
        this.moduleReplacements = moduleReplacements;
        this.compositeResolver.addFirst(conflictResolver);
    }

    @Override
    @Nullable
    public PotentialConflict registerModule(CandidateModule newModule) {
        ModuleIdentifier replacedBy = this.moduleReplacements.getReplacementFor(newModule.getId());
        return PotentialConflictFactory.potentialConflict(this.conflicts.newElement(newModule.getId(), newModule.getVersions(), replacedBy));
    }

    @Override
    public boolean hasConflicts() {
        return this.conflicts.getSize() > 0;
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        assert (this.hasConflicts());
        ConflictContainer.Conflict conflict = this.conflicts.popConflict();
        Object selected = this.compositeResolver.select(conflict.candidates);
        DefaultConflictResolutionResult result = new DefaultConflictResolutionResult(PotentialConflictFactory.potentialConflict(conflict), (ComponentResolutionState)selected);
        resolutionAction.execute((Object)result);
        LOGGER.debug("Selected {} from conflicting modules {}.", selected, conflict.candidates);
    }

    @Override
    public void registerResolver(ModuleConflictResolver conflictResolver) {
        this.compositeResolver.addFirst(conflictResolver);
    }
}

