/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResultBuilder;
import org.gradle.internal.component.local.model.LocalConfigurationMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;

public class ResolvedLocalComponentsResultGraphVisitor
implements DependencyGraphVisitor {
    private final ResolvedLocalComponentsResultBuilder builder;
    private ComponentIdentifier rootId;

    public ResolvedLocalComponentsResultGraphVisitor(ResolvedLocalComponentsResultBuilder builder) {
        this.builder = builder;
    }

    public void start(DependencyGraphNode root) {
        this.rootId = root.getComponentId();
    }

    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        ConfigurationMetaData configurationMetaData;
        if (this.rootId.equals(resolvedConfiguration.getComponentId())) {
            return;
        }
        ComponentIdentifier componentId = resolvedConfiguration.getComponentId();
        if (componentId instanceof ProjectComponentIdentifier) {
            this.builder.projectConfigurationResolved((ProjectComponentIdentifier)componentId, resolvedConfiguration.getNodeId().getConfiguration());
        }
        if ((configurationMetaData = resolvedConfiguration.getMetaData()) instanceof LocalConfigurationMetaData) {
            this.builder.localComponentResolved(componentId, ((LocalConfigurationMetaData)configurationMetaData).getDirectBuildDependencies());
        }
    }

    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
    }

    public void finish(DependencyGraphNode root) {
    }
}

