/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.DefaultScalaPlatform;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.play.internal.DefaultPlayPlatform;
import org.gradle.play.internal.PlayPlatformRequirement;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayPlatformResolver
implements PlatformResolver<PlayPlatform> {
    public Class<PlayPlatform> getType() {
        return PlayPlatform.class;
    }

    public PlayPlatform resolve(PlatformRequirement platformRequirement) {
        if (platformRequirement instanceof PlayPlatformRequirement) {
            PlayPlatformRequirement requirement = (PlayPlatformRequirement)platformRequirement;
            return this.resolve(requirement.getPlatformName(), requirement.getPlayVersion(), requirement.getScalaVersion(), requirement.getJavaVersion());
        }
        String playVersion = this.parsePlayVersionFromPlatformName(platformRequirement.getPlatformName());
        return this.resolve(platformRequirement.getPlatformName(), playVersion, null, null);
    }

    private PlayPlatform resolve(String name, String playVersion, String scalaVersion, String javaVersion) {
        PlayMajorVersion playMajorVersion = PlayMajorVersion.forPlayVersion(playVersion);
        JavaPlatform javaPlatform = this.getJavaPlatform(javaVersion);
        ScalaPlatform scalaPlatform = this.getScalaPlatform(playMajorVersion, scalaVersion);
        return new DefaultPlayPlatform(name, playVersion, scalaPlatform, javaPlatform);
    }

    private String parsePlayVersionFromPlatformName(String playPlatformName) {
        if (playPlatformName.startsWith("play-")) {
            return playPlatformName.substring(5);
        }
        throw new InvalidUserDataException(String.format("Not a valid Play platform: %s.", playPlatformName));
    }

    private JavaPlatform getJavaPlatform(String preferredJavaVersion) {
        if (preferredJavaVersion != null) {
            return new DefaultJavaPlatform(JavaVersion.toVersion((Object)preferredJavaVersion));
        }
        return new DefaultJavaPlatform(JavaVersion.current());
    }

    private ScalaPlatform getScalaPlatform(PlayMajorVersion playMajorVersion, String preferredScalaVersion) {
        String scalaVersion = (String)GUtil.elvis((Object)preferredScalaVersion, (Object)playMajorVersion.getDefaultScalaPlatform());
        ScalaPlatform scalaPlatform = this.createScalaPlatform(scalaVersion);
        playMajorVersion.validateCompatible(scalaPlatform);
        return scalaPlatform;
    }

    private ScalaPlatform createScalaPlatform(String compatibilityVersion) {
        if ("2.10".equals(compatibilityVersion)) {
            return new DefaultScalaPlatform("2.10.4");
        }
        if ("2.11".equals(compatibilityVersion)) {
            return new DefaultScalaPlatform("2.11.4");
        }
        throw new InvalidUserDataException(String.format("Not a supported Scala platform identifier %s. Supported values are: ['2.10', '2.11'].", compatibilityVersion));
    }
}

