/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Iterator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractFileSnapshotTaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;
    private final OutputFilesCollectionSnapshotter outputFilesSnapshotter;
    private final FileCollectionSnapshot.PreCheck outputFilesBeforePreCheck;
    private final boolean noChanges;
    private FileCollectionSnapshot outputFilesBefore;

    public OutputFilesTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task, OutputFilesCollectionSnapshotter outputFilesSnapshotter) {
        super(task.getName());
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.outputFilesBeforePreCheck = this.createSnapshotPreCheck(outputFilesSnapshotter, task.getOutputs().getFiles());
        this.noChanges = previousExecution != null && previousExecution.getOutputFilesHash() != null && previousExecution.getOutputFilesHash().equals(this.outputFilesBeforePreCheck.getHash());
    }

    @Override
    protected String getInputFileType() {
        return "Output";
    }

    @Override
    public FileCollectionSnapshot getPrevious() {
        return this.previousExecution.getOutputFilesSnapshot();
    }

    @Override
    public FileCollectionSnapshot getCurrent() {
        if (this.outputFilesBefore == null) {
            this.outputFilesBefore = this.outputFilesSnapshotter.snapshot(this.outputFilesBeforePreCheck);
        }
        return this.outputFilesBefore;
    }

    @Override
    protected FileCollectionSnapshot.ChangeIterator<String> getChanges() {
        return this.getCurrent().iterateContentChangesSince(this.getPrevious(), EnumSet.of(FileCollectionSnapshot.ChangeFilter.IgnoreAddedFiles));
    }

    @Override
    public void saveCurrent() {
        FileCollectionSnapshot lastExecutionOutputFiles = this.previousExecution == null || this.previousExecution.getOutputFilesSnapshot() == null ? this.outputFilesSnapshotter.emptySnapshot() : this.previousExecution.getOutputFilesSnapshot();
        FileCollectionSnapshot.PreCheck outputFilesAfterPreCheck = this.createSnapshotPreCheck(this.outputFilesSnapshotter, this.task.getOutputs().getFiles());
        FileCollectionSnapshot outputFilesAfter = this.createSnapshot(this.outputFilesSnapshotter, outputFilesAfterPreCheck);
        this.currentExecution.setOutputFilesSnapshot(this.outputFilesSnapshotter.createOutputSnapshot(lastExecutionOutputFiles, this.outputFilesBefore, outputFilesAfter, this.task.getOutputs().getFiles()));
        this.currentExecution.setOutputFilesHash(outputFilesAfterPreCheck.getHash());
    }

    @Override
    protected boolean isAllowSnapshotReuse() {
        return false;
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.noChanges) {
            return Iterators.emptyIterator();
        }
        return super.iterator();
    }
}

