/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshotRepository;
import org.gradle.api.internal.changedetection.state.TreeSnapshotSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileSnapshotterSerializer
implements Serializer<FileCollectionSnapshotImpl> {
    private final StringInterner stringInterner;
    private final TreeSnapshotRepository treeSnapshotRepository;
    private final IncrementalFileSnapshotSerializer incrementalFileSnapshotSerializer = new IncrementalFileSnapshotSerializer();

    public DefaultFileSnapshotterSerializer(StringInterner stringInterner, TreeSnapshotRepository treeSnapshotRepository) {
        this.stringInterner = stringInterner;
        this.treeSnapshotRepository = treeSnapshotRepository;
    }

    public FileCollectionSnapshotImpl read(Decoder decoder) throws Exception {
        ArrayList<TreeSnapshot> treeSnapshots = new ArrayList<TreeSnapshot>();
        int sharedTreeCount = decoder.readSmallInt();
        for (int i = 0; i < sharedTreeCount; ++i) {
            long treeId = decoder.readLong();
            treeSnapshots.add(this.treeSnapshotRepository.getTreeSnapshot(treeId));
        }
        TreeSnapshot nonShared = TreeSnapshotSerializer.readStoredTreeSnapshot(-1L, decoder, this.incrementalFileSnapshotSerializer, this.stringInterner);
        if (!nonShared.getFileSnapshots().isEmpty()) {
            treeSnapshots.add(nonShared);
        }
        return new FileCollectionSnapshotImpl(treeSnapshots);
    }

    public void write(Encoder encoder, FileCollectionSnapshotImpl value) throws Exception {
        List<TreeSnapshot> treeSnapshots = value.treeSnapshots;
        if (treeSnapshots != null) {
            TreeSnapshot nonShared = null;
            for (TreeSnapshot snapshot : treeSnapshots) {
                if (snapshot.isShareable()) continue;
                if (nonShared != null) {
                    throw new RuntimeException("Multiple non-shared snapshots aren't supported.");
                }
                nonShared = snapshot;
            }
            encoder.writeSmallInt(treeSnapshots.size() - (nonShared != null ? 1 : 0));
            for (TreeSnapshot snapshot : treeSnapshots) {
                if (!snapshot.isShareable()) continue;
                encoder.writeLong(this.treeSnapshotRepository.maybeStoreTreeSnapshot(snapshot));
            }
            if (nonShared != null) {
                TreeSnapshotSerializer.writeTreeSnapshot(nonShared, encoder, this.incrementalFileSnapshotSerializer);
            } else {
                encoder.writeSmallInt(0);
            }
        } else {
            encoder.writeSmallInt(0);
            encoder.writeSmallInt(value.snapshots.size());
            for (Map.Entry<String, IncrementalFileSnapshot> entry : value.snapshots.entrySet()) {
                encoder.writeString((CharSequence)entry.getKey());
                this.incrementalFileSnapshotSerializer.write(encoder, entry.getValue());
            }
        }
    }
}

