/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileSnapshotWithKey;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.StoredTreeSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeSnapshotSerializer
implements Serializer<TreeSnapshot> {
    private final IncrementalFileSnapshotSerializer incrementalFileSnapshotSerializer = new IncrementalFileSnapshotSerializer();
    private final StringInterner stringInterner;

    public TreeSnapshotSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public TreeSnapshot read(Decoder decoder) throws EOFException, Exception {
        long assignedId = decoder.readLong();
        return TreeSnapshotSerializer.readStoredTreeSnapshot(assignedId, decoder, this.incrementalFileSnapshotSerializer, this.stringInterner);
    }

    public void write(Encoder encoder, TreeSnapshot value) throws Exception {
        encoder.writeLong(value.getAssignedId().longValue());
        TreeSnapshotSerializer.writeTreeSnapshot(value, encoder, this.incrementalFileSnapshotSerializer);
    }

    static void writeTreeSnapshot(TreeSnapshot treeSnapshot, Encoder encoder, IncrementalFileSnapshotSerializer incrementalFileSnapshotSerializer) throws Exception {
        encoder.writeSmallInt(treeSnapshot.getFileSnapshots().size());
        for (FileSnapshotWithKey fileSnapshotWithKey : treeSnapshot.getFileSnapshots()) {
            encoder.writeString((CharSequence)fileSnapshotWithKey.getKey());
            incrementalFileSnapshotSerializer.write(encoder, fileSnapshotWithKey.getIncrementalFileSnapshot());
        }
    }

    static TreeSnapshot readStoredTreeSnapshot(long assignedId, Decoder decoder, IncrementalFileSnapshotSerializer incrementalFileSnapshotSerializer, StringInterner stringInterner) throws Exception {
        int entryCount = decoder.readSmallInt();
        ImmutableList.Builder fileSnapshotWithKeyListBuilder = ImmutableList.builder();
        for (int i = 0; i < entryCount; ++i) {
            String key = stringInterner.intern(decoder.readString());
            fileSnapshotWithKeyListBuilder.add((Object)new FileSnapshotWithKey(key, incrementalFileSnapshotSerializer.read(decoder)));
        }
        ImmutableList fileSnapshotWithKeyList = fileSnapshotWithKeyListBuilder.build();
        return new StoredTreeSnapshot((ImmutableList<FileSnapshotWithKey>)fileSnapshotWithKeyList, assignedId);
    }
}

