/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class BufferedStreamingHasher {
    private final KryoBackedEncoder encoder;
    private final Checksum checksum = new CRC32();

    public BufferedStreamingHasher() {
        this.encoder = new KryoBackedEncoder(new OutputStream(){

            public void write(int b) throws IOException {
                BufferedStreamingHasher.this.checksum.update(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                BufferedStreamingHasher.this.checksum.update(b, off, len);
            }
        });
    }

    public int checksum() {
        this.encoder.flush();
        return (int)this.checksum.getValue();
    }

    public Encoder getEncoder() {
        return this.encoder;
    }
}

