/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.CompressedReadableResource;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.bundling.Compression;

public class MaybeCompressedFileResource
implements ReadableResourceInternal {
    private final ReadableResourceInternal resource;

    public MaybeCompressedFileResource(ReadableResourceInternal resource) {
        if (resource instanceof CompressedReadableResource) {
            this.resource = resource;
        } else {
            String ext = FilenameUtils.getExtension((String)resource.getURI().toString());
            this.resource = Compression.BZIP2.getSupportedExtensions().contains(ext) ? new Bzip2Archiver(resource) : (Compression.GZIP.getSupportedExtensions().contains(ext) ? new GzipArchiver(resource) : resource);
        }
    }

    public InputStream read() throws MissingResourceException {
        return this.resource.read();
    }

    public ReadableResource getResource() {
        return this.resource;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }

    public File getBackingFile() {
        return this.resource.getBackingFile();
    }
}

