/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private final DefaultConfigurableFileCollection outputFiles;
    private AndSpec<TaskInternal> upToDateSpec = new AndSpec(new Spec[0]);
    private TaskExecutionHistory history;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.taskMutator = taskMutator;
        this.outputFiles = new DefaultConfigurableFileCollection(task + " output files", resolver, null, new Object[0]);
        this.outputFiles.builtBy(task);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    @Override
    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public boolean getHasOutput() {
        return !this.outputFiles.getFrom().isEmpty() || !this.upToDateSpec.getSpecs().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.outputFiles;
    }

    @Override
    public TaskOutputs files(final Object ... paths) {
        this.taskMutator.mutate("TaskOutputs.files(Object...)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.outputFiles.from(paths);
            }
        });
        return this;
    }

    @Override
    public TaskOutputs file(final Object path) {
        this.taskMutator.mutate("TaskOutputs.file(Object)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.outputFiles.from(path);
            }
        });
        return this;
    }

    @Override
    public TaskOutputs dir(final Object path) {
        this.taskMutator.mutate("TaskOutputs.dir(Object)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.outputFiles.from(path);
            }
        });
        return this;
    }

    @Override
    public FileCollection getPreviousFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory history) {
        this.history = history;
    }
}

