/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.xml;

public class XmlValidation {
    public static boolean isValidXmlName(String name) {
        if (name.indexOf(58) != name.lastIndexOf(58)) {
            return false;
        }
        if (name.indexOf(58) != -1 && name.charAt(0) != ':') {
            return XmlValidation.isValidXmlName(name.substring(0, name.indexOf(58))) && XmlValidation.isValidXmlName(name.substring(name.indexOf(58) + 1));
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!XmlValidation.isValidNameStartChar(ch)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            ch = name.charAt(i);
            if (XmlValidation.isValidNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNameChar(char ch) {
        if (XmlValidation.isValidNameStartChar(ch)) {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch == '-' || ch == '.' || ch == '\u00b7') {
            return true;
        }
        if (ch >= '\u0300' && ch <= '\u036f') {
            return true;
        }
        return ch >= '\u203f' && ch <= '\u2040';
    }

    private static boolean isValidNameStartChar(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch == ':' || ch == '_') {
            return true;
        }
        if (ch >= '\u00c0' && ch <= '\u00d6') {
            return true;
        }
        if (ch >= '\u00d8' && ch <= '\u00f6') {
            return true;
        }
        if (ch >= '\u00f8' && ch <= '\u02ff') {
            return true;
        }
        if (ch >= '\u0370' && ch <= '\u037d') {
            return true;
        }
        if (ch >= '\u037f' && ch <= '\u1fff') {
            return true;
        }
        if (ch >= '\u200c' && ch <= '\u200d') {
            return true;
        }
        if (ch >= '\u2070' && ch <= '\u218f') {
            return true;
        }
        if (ch >= '\u2c00' && ch <= '\u2fef') {
            return true;
        }
        if (ch >= '\u3001' && ch <= '\ud7ff') {
            return true;
        }
        if (ch >= '\uf900' && ch <= '\ufdcf') {
            return true;
        }
        return ch >= '\ufdf0' && ch <= '\ufffd';
    }

    public static boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        if (c <= '\ufffd') {
            return true;
        }
        if (c < '\u10000') {
            return false;
        }
        return c <= '\u10ffff';
    }

    public static boolean isRestrictedCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r' || c == '\u0085') {
            return false;
        }
        if (c <= '\u001f') {
            return true;
        }
        if (c < '\u007f') {
            return false;
        }
        return c <= '\u009f';
    }
}

