/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public abstract class ECPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    ASN1ObjectIdentifier oid;
    ECPoint point;

    protected ECPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.oid = ASN1ObjectIdentifier.getInstance((Object)ASN1Primitive.fromByteArray((byte[])ECPublicBCPGKey.readBytesOfEncodedLength(bCPGInputStream)));
        this.point = ECPublicBCPGKey.decodePoint(new MPInteger(bCPGInputStream).getValue(), this.oid);
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, ECPoint eCPoint) {
        this.point = eCPoint.normalize();
        this.oid = aSN1ObjectIdentifier;
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger) throws IOException {
        this.point = ECPublicBCPGKey.decodePoint(bigInteger, aSN1ObjectIdentifier);
        this.oid = aSN1ObjectIdentifier;
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            bCPGOutputStream.writeObject(this);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        byte[] byArray = this.oid.getEncoded();
        bCPGOutputStream.write(byArray, 1, byArray.length - 1);
        MPInteger mPInteger = new MPInteger(new BigInteger(1, this.point.getEncoded()));
        bCPGOutputStream.writeObject(mPInteger);
    }

    public ECPoint getPoint() {
        return this.point;
    }

    public ASN1ObjectIdentifier getCurveOID() {
        return this.oid;
    }

    protected static byte[] readBytesOfEncodedLength(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.read();
        if (n == 0 || n == 255) {
            throw new IOException("future extensions not yet implemented.");
        }
        byte[] byArray = new byte[n + 2];
        bCPGInputStream.readFully(byArray, 2, byArray.length - 2);
        byArray[0] = 6;
        byArray[1] = (byte)n;
        return byArray;
    }

    private static ECPoint decodePoint(BigInteger bigInteger, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier)) == null) {
            throw new IOException(aSN1ObjectIdentifier.getId() + " does not match any known curve.");
        }
        if (!ECAlgorithms.isFpCurve((ECCurve)x9ECParameters.getCurve())) {
            throw new IOException("Only prime field curves are supported.");
        }
        return x9ECParameters.getCurve().decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }
}

