/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.action.MavenWagonDeployAction;
import org.gradle.api.publication.maven.internal.deployer.AbstractMavenResolver;
import org.gradle.internal.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMavenDeployer
extends AbstractMavenResolver
implements MavenDeployer {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private Configuration configuration;
    private List<File> protocolProviderJars = new ArrayList<File>();
    private boolean uniqueVersion = true;

    public BaseMavenDeployer(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager, MavenSettingsProvider mavenSettingsProvider, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        super(pomFilterContainer, artifactPomContainer, loggingManager, mavenSettingsProvider, mavenRepositoryLocator);
    }

    @Override
    protected MavenPublishAction createPublishAction(File pomFile, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        MavenWagonDeployAction deployAction = new MavenWagonDeployAction(pomFile, this.getJars());
        deployAction.setLocalMavenRepositoryLocation(mavenRepositoryLocator.getLocalMavenRepository());
        deployAction.setUniqueVersion(this.isUniqueVersion());
        deployAction.setRepositories(this.remoteRepository, this.remoteSnapshotRepository);
        return deployAction;
    }

    private List<File> getJars() {
        return this.configuration != null ? new ArrayList(this.configuration.resolve()) : this.protocolProviderJars;
    }

    public RemoteRepository getRepository() {
        return this.remoteRepository;
    }

    @Override
    public void setRepository(Object remoteRepository) {
        this.remoteRepository = (RemoteRepository)((Object)remoteRepository);
    }

    public RemoteRepository getSnapshotRepository() {
        return this.remoteSnapshotRepository;
    }

    @Override
    public void setSnapshotRepository(Object remoteSnapshotRepository) {
        this.remoteSnapshotRepository = (RemoteRepository)((Object)remoteSnapshotRepository);
    }

    @Override
    public void addProtocolProviderJars(Collection<File> jars) {
        this.protocolProviderJars.addAll(jars);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isUniqueVersion() {
        return this.uniqueVersion;
    }

    @Override
    public void setUniqueVersion(boolean uniqueVersion) {
        this.uniqueVersion = uniqueVersion;
    }
}

