/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableURLClassLoader
extends URLClassLoader
implements ClassLoaderHierarchy {
    public MutableURLClassLoader(ClassLoader parent, URL ... urls) {
        super(urls, parent);
    }

    public MutableURLClassLoader(ClassLoader parent, Collection<URL> urls) {
        super(urls.toArray(new URL[0]), parent);
    }

    public MutableURLClassLoader(ClassLoader parent, ClassPath classPath) {
        super(classPath.getAsURLArray(), parent);
    }

    public MutableURLClassLoader(ClassLoader parent, Spec spec) {
        this(parent, spec.classpath);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec(CollectionUtils.toList(this.getURLs())));
        visitor.visitClassPath(this.getURLs());
        visitor.visitParent(this.getParent());
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addURLs(Iterable<URL> urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Spec
    extends ClassLoaderSpec {
        final List<URL> classpath;

        public Spec(List<URL> classpath) {
            this.classpath = classpath;
        }

        public List<URL> getClasspath() {
            return this.classpath;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " classpath:" + this.classpath + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return this.classpath.equals(other.classpath);
        }

        public int hashCode() {
            return this.classpath.hashCode();
        }
    }
}

