/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.MultipleBuildOperationFailures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBuildOperationQueue<T extends BuildOperation>
implements BuildOperationQueue<T> {
    private final ListeningExecutorService executor;
    private final BuildOperationWorker<T> worker;
    private final List<QueuedOperation> operations;
    private String logLocation;
    private final AtomicBoolean waitingForCompletion = new AtomicBoolean();
    private final AtomicBoolean canceled = new AtomicBoolean();

    DefaultBuildOperationQueue(ExecutorService executor, BuildOperationWorker<T> worker) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.worker = worker;
        this.operations = Collections.synchronizedList(Lists.newArrayList());
    }

    @Override
    public void add(T operation) {
        if (this.waitingForCompletion.get()) {
            throw new IllegalStateException("BuildOperationQueue cannot be reused once it has started completion.");
        }
        OperationHolder operationHolder = new OperationHolder(this, operation);
        ListenableFuture future = this.executor.submit((Runnable)operationHolder);
        this.operations.add(new QueuedOperation(operationHolder, future));
    }

    @Override
    public void cancel() {
        this.canceled.set(true);
        for (QueuedOperation operation : this.operations) {
            if (operation.operationHolder.isStarted()) continue;
            operation.future.cancel(false);
        }
    }

    @Override
    public void waitForCompletion() throws MultipleBuildOperationFailures {
        this.waitingForCompletion.set(true);
        CountDownLatch finished = new CountDownLatch(this.operations.size());
        ConcurrentLinkedQueue failures = Queues.newConcurrentLinkedQueue();
        for (QueuedOperation operation : this.operations) {
            if (operation.future.isCancelled()) {
                finished.countDown();
                continue;
            }
            Futures.addCallback((ListenableFuture)operation.future, (FutureCallback)new CompletionCallback(finished, failures));
        }
        try {
            finished.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        if (!failures.isEmpty()) {
            throw new MultipleBuildOperationFailures(DefaultBuildOperationQueue.getFailureMessage(failures), failures, this.logLocation);
        }
    }

    @Override
    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    private static String getFailureMessage(Collection<? extends Throwable> failures) {
        if (failures.size() == 1) {
            return "A build operation failed.";
        }
        return "Multiple build operations failed.";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperationHolder
    implements Runnable {
        private final T operation;
        private final AtomicBoolean started = new AtomicBoolean();
        final /* synthetic */ DefaultBuildOperationQueue this$0;

        OperationHolder(T operation) {
            this.this$0 = var1_1;
            this.operation = operation;
        }

        @Override
        public void run() {
            this.started.set(!this.this$0.canceled.get());
            if (this.started.get()) {
                this.this$0.worker.execute(this.operation);
            }
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public String toString() {
            return "Worker ".concat(this.this$0.worker.getDisplayName()).concat(" for operation ").concat(this.operation.getDescription());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuedOperation {
        final OperationHolder operationHolder;
        final ListenableFuture future;

        public QueuedOperation(OperationHolder operationHolder, ListenableFuture future) {
            this.operationHolder = operationHolder;
            this.future = future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompletionCallback
    implements FutureCallback {
        private final CountDownLatch finished;
        private final Collection<Throwable> failures;

        private CompletionCallback(CountDownLatch finished, Collection<Throwable> failures) {
            this.finished = finished;
            this.failures = failures;
        }

        public void onSuccess(Object result) {
            this.finished.countDown();
        }

        public void onFailure(Throwable t) {
            this.failures.add(t);
            this.finished.countDown();
        }
    }
}

