/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.annotation.ThreadSafe;
import org.gradle.plugin.repository.GradlePluginPortal;
import org.gradle.plugin.repository.PluginRepository;
import org.gradle.plugin.repository.internal.PluginRepositoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultPluginRepositoryRegistry
implements PluginRepositoryRegistry {
    private final List<PluginRepository> repositories = new ArrayList<PluginRepository>();
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final AtomicBoolean portalAdded = new AtomicBoolean(false);

    public void add(PluginRepository pluginRepository) {
        if (pluginRepository instanceof GradlePluginPortal) {
            this.addPortal(pluginRepository);
        } else {
            this.addRepository(pluginRepository);
        }
    }

    public void lock() {
        this.locked.set(true);
    }

    public ImmutableList<PluginRepository> getPluginRepositories() {
        if (this.locked.get()) {
            return ImmutableList.copyOf(this.repositories);
        }
        throw new IllegalStateException("Cannot read the PluginRepository list when the Registry is unlocked.");
    }

    private void addPortal(PluginRepository pluginPortal) {
        if (!this.portalAdded.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot add Gradle Plugin Portal more than once.");
        }
        this.addRepository(pluginPortal);
    }

    private void addRepository(PluginRepository pluginRepository) {
        if (this.locked.get()) {
            throw new IllegalStateException("Cannot add a PluginRepository when the Registry is locked.");
        }
        this.repositories.add(pluginRepository);
    }
}

