/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class NotNonCorePluginOnClasspathCheckPluginResolver
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;

    public NotNonCorePluginOnClasspathCheckPluginResolver(PluginResolver delegate, PluginRegistry corePluginRegistry, PluginDescriptorLocator pluginDescriptorLocator) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
    }

    public void resolve(PluginRequest pluginRequest, PluginResolutionResult result) {
        PluginId pluginId = pluginRequest.getId();
        PluginDescriptor pluginDescriptor = this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString());
        if (pluginDescriptor != null && !this.isCorePlugin(pluginId)) {
            throw new InvalidPluginRequestException(pluginRequest, NotNonCorePluginOnClasspathCheckPluginResolver.pluginOnClasspathErrorMessage(pluginId.toString()));
        }
        this.delegate.resolve(pluginRequest, result);
    }

    public static String pluginOnClasspathErrorMessage(String pluginId) {
        return String.format("Plugin '%s' is already on the script classpath. Plugins on the script classpath cannot be applied in the plugins {} block. Add  \"apply plugin: '%s'\" to the body of the script to use the plugin.", pluginId, pluginId);
    }

    private boolean isCorePlugin(PluginId pluginId) {
        return this.corePluginRegistry.lookup(pluginId) != null;
    }
}

