/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.GradleException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.internal.consumer.CancellationTokenInternal;
import org.gradle.tooling.internal.consumer.CompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ProjectConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.BuildProgressListenerAdapter;
import org.gradle.tooling.internal.consumer.parameters.FailsafeBuildProgressListenerAdapter;
import org.gradle.tooling.internal.consumer.parameters.ProgressListenerAdapter;
import org.gradle.tooling.internal.gradle.TaskListingLaunchable;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.Launchable;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerOperationParameters
implements BuildOperationParametersVersion1,
BuildParametersVersion1,
BuildParameters {
    private final String entryPointName;
    private final ProgressListenerAdapter progressListener;
    private final FailsafeBuildProgressListenerAdapter buildProgressListener;
    private final CancellationToken cancellationToken;
    private final ConnectionParameters parameters;
    private final long startTime = System.currentTimeMillis();
    private final OutputStream stdout;
    private final OutputStream stderr;
    private final Boolean colorOutput;
    private final InputStream stdin;
    private final File javaHome;
    private final List<String> jvmArguments;
    private final List<String> arguments;
    private final List<String> tasks;
    private final List<InternalLaunchable> launchables;
    private final ClassPath injectedPluginClasspath;
    private final BuildIdentifier buildIdentifier;
    private final List<ProgressListener> legacyProgressListeners;
    private final List<org.gradle.tooling.events.ProgressListener> testProgressListeners;
    private final List<org.gradle.tooling.events.ProgressListener> taskProgressListeners;
    private final List<org.gradle.tooling.events.ProgressListener> buildOperationProgressListeners;

    public static Builder builder() {
        return new Builder();
    }

    private ConsumerOperationParameters(String entryPointName, ConnectionParameters parameters, OutputStream stdout, OutputStream stderr, Boolean colorOutput, InputStream stdin, File javaHome, List<String> jvmArguments, List<String> arguments, List<String> tasks, List<InternalLaunchable> launchables, ClassPath injectedPluginClasspath, List<ProgressListener> legacyProgressListeners, List<org.gradle.tooling.events.ProgressListener> testProgressListeners, List<org.gradle.tooling.events.ProgressListener> taskProgressListeners, List<org.gradle.tooling.events.ProgressListener> buildOperationProgressListeners, CancellationToken cancellationToken, BuildIdentifier buildIdentifier) {
        this.entryPointName = entryPointName;
        this.parameters = parameters;
        this.stdout = stdout;
        this.stderr = stderr;
        this.colorOutput = colorOutput;
        this.stdin = stdin;
        this.javaHome = javaHome;
        this.jvmArguments = jvmArguments;
        this.arguments = arguments;
        this.tasks = tasks;
        this.launchables = launchables;
        this.injectedPluginClasspath = injectedPluginClasspath;
        this.cancellationToken = cancellationToken;
        this.buildIdentifier = buildIdentifier;
        this.legacyProgressListeners = legacyProgressListeners;
        this.testProgressListeners = testProgressListeners;
        this.taskProgressListeners = taskProgressListeners;
        this.buildOperationProgressListeners = buildOperationProgressListeners;
        this.progressListener = new ProgressListenerAdapter(this.legacyProgressListeners);
        this.buildProgressListener = new FailsafeBuildProgressListenerAdapter(new BuildProgressListenerAdapter(this.testProgressListeners, this.taskProgressListeners, this.buildOperationProgressListeners));
    }

    private static void validateJavaHome(File javaHome) {
        if (javaHome == null) {
            return;
        }
        if (!javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome is not a valid folder. You supplied: " + javaHome);
        }
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean getVerboseLogging() {
        return this.parameters.getVerboseLogging();
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.parameters.getGradleUserHomeDir();
    }

    @Override
    public File getProjectDir() {
        return this.parameters instanceof ProjectConnectionParameters ? ((ProjectConnectionParameters)this.parameters).getProjectDir() : null;
    }

    @Override
    public Boolean isSearchUpwards() {
        return this.parameters instanceof ProjectConnectionParameters ? ((ProjectConnectionParameters)this.parameters).isSearchUpwards() : Boolean.FALSE;
    }

    @Override
    public Boolean isEmbedded() {
        return this.parameters.isEmbedded();
    }

    @Override
    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.parameters.getDaemonMaxIdleTimeUnits();
    }

    @Override
    public Integer getDaemonMaxIdleTimeValue() {
        return this.parameters.getDaemonMaxIdleTimeValue();
    }

    public File getDaemonBaseDir() {
        return this.parameters.getDaemonBaseDir();
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.stdout;
    }

    @Override
    public OutputStream getStandardError() {
        return this.stderr;
    }

    public Boolean isColorOutput() {
        return this.colorOutput;
    }

    @Override
    public InputStream getStandardInput() {
        return this.stdin;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public List<String> getTasks() {
        return this.tasks;
    }

    public List<InternalLaunchable> getLaunchables() {
        return this.launchables;
    }

    public List<File> getInjectedPluginClasspath() {
        return this.injectedPluginClasspath.getAsFiles();
    }

    @Override
    public ProgressListenerVersion1 getProgressListener() {
        return this.progressListener;
    }

    public FailsafeBuildProgressListenerAdapter getBuildProgressListener() {
        return this.buildProgressListener;
    }

    public BuildCancellationToken getCancellationToken() {
        return ((CancellationTokenInternal)((Object)this.cancellationToken)).getToken();
    }

    public List<GradleParticipantBuild> getBuilds() {
        if (!(this.parameters instanceof CompositeConnectionParameters)) {
            return null;
        }
        List<GradleParticipantBuild> unorderedBuilds = ((CompositeConnectionParameters)this.parameters).getBuilds();
        if (this.buildIdentifier == null) {
            return unorderedBuilds;
        }
        GradleParticipantBuild targetBuild = null;
        LinkedList<GradleParticipantBuild> builds = new LinkedList<GradleParticipantBuild>();
        for (GradleParticipantBuild build : unorderedBuilds) {
            DefaultBuildIdentifier participantIdentifier = new DefaultBuildIdentifier(build.getProjectDir());
            if (((Object)participantIdentifier).equals(this.buildIdentifier)) {
                targetBuild = build;
                continue;
            }
            builds.add(build);
        }
        if (targetBuild == null) {
            throw new GradleConnectionException("Not a valid build: " + this.buildIdentifier, new IllegalStateException("Build not part of composite"));
        }
        builds.add(0, targetBuild);
        return builds;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<ProgressListener> legacyProgressListeners = new ArrayList<ProgressListener>();
        private final List<org.gradle.tooling.events.ProgressListener> testProgressListeners = new ArrayList<org.gradle.tooling.events.ProgressListener>();
        private final List<org.gradle.tooling.events.ProgressListener> taskProgressListeners = new ArrayList<org.gradle.tooling.events.ProgressListener>();
        private final List<org.gradle.tooling.events.ProgressListener> buildOperationProgressListeners = new ArrayList<org.gradle.tooling.events.ProgressListener>();
        private String entryPoint;
        private CancellationToken cancellationToken;
        private ConnectionParameters parameters;
        private OutputStream stdout;
        private OutputStream stderr;
        private Boolean colorOutput;
        private InputStream stdin;
        private File javaHome;
        private List<String> jvmArguments;
        private List<String> arguments;
        private List<String> tasks;
        private List<InternalLaunchable> launchables;
        private ClassPath injectedPluginClasspath = ClassPath.EMPTY;
        private BuildIdentifier buildIdentifier;

        private Builder() {
        }

        public Builder setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public Builder setParameters(ConnectionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setStdout(OutputStream stdout) {
            this.stdout = stdout;
            return this;
        }

        public Builder setStderr(OutputStream stderr) {
            this.stderr = stderr;
            return this;
        }

        public Builder setColorOutput(Boolean colorOutput) {
            this.colorOutput = colorOutput;
            return this;
        }

        public Builder setStdin(InputStream stdin) {
            this.stdin = stdin;
            return this;
        }

        public Builder setJavaHome(File javaHome) {
            ConsumerOperationParameters.validateJavaHome(javaHome);
            this.javaHome = javaHome;
            return this;
        }

        public Builder setJvmArguments(List<String> jvmArguments) {
            this.jvmArguments = jvmArguments;
            return this;
        }

        public Builder setArguments(List<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder setTasks(List<String> tasks) {
            this.tasks = tasks;
            return this;
        }

        public Builder setLaunchables(Iterable<? extends Launchable> launchables) {
            LinkedHashSet<String> taskPaths = new LinkedHashSet<String>();
            ArrayList launchablesParams = Lists.newArrayList();
            for (Launchable launchable : launchables) {
                Object original = new ProtocolToModelAdapter().unpack(launchable);
                if (original instanceof InternalLaunchable) {
                    launchablesParams.add((InternalLaunchable)original);
                    continue;
                }
                if (original instanceof TaskListingLaunchable) {
                    taskPaths.addAll(((TaskListingLaunchable)original).getTaskNames());
                    continue;
                }
                if (launchable instanceof Task) {
                    taskPaths.add(((Task)launchable).getPath());
                    continue;
                }
                throw new GradleException("Only Task or TaskSelector instances are supported: " + (launchable != null ? launchable.getClass() : "null"));
            }
            this.launchables = launchablesParams.isEmpty() ? null : launchablesParams;
            this.tasks = Lists.newArrayList(taskPaths);
            return this;
        }

        public Builder setInjectedPluginClasspath(ClassPath classPath) {
            this.injectedPluginClasspath = classPath;
            return this;
        }

        public void addProgressListener(ProgressListener listener) {
            this.legacyProgressListeners.add(listener);
        }

        public void addTestProgressListener(org.gradle.tooling.events.ProgressListener listener) {
            this.testProgressListeners.add(listener);
        }

        public void addTaskProgressListener(org.gradle.tooling.events.ProgressListener listener) {
            this.taskProgressListeners.add(listener);
        }

        public void addBuildOperationProgressListeners(org.gradle.tooling.events.ProgressListener listener) {
            this.buildOperationProgressListeners.add(listener);
        }

        public void setCancellationToken(CancellationToken cancellationToken) {
            this.cancellationToken = cancellationToken;
        }

        public Builder setRootDirectory(File rootDirectory) {
            this.buildIdentifier = new DefaultBuildIdentifier(rootDirectory);
            return this;
        }

        public Builder setBuildIdentifier(BuildIdentifier buildIdentifier) {
            this.buildIdentifier = buildIdentifier;
            return this;
        }

        public ConsumerOperationParameters build() {
            if (this.entryPoint == null) {
                throw new IllegalStateException("No entry point specified.");
            }
            return new ConsumerOperationParameters(this.entryPoint, this.parameters, this.stdout, this.stderr, this.colorOutput, this.stdin, this.javaHome, this.jvmArguments, this.arguments, this.tasks, this.launchables, this.injectedPluginClasspath, this.legacyProgressListeners, this.testProgressListeners, this.taskProgressListeners, this.buildOperationProgressListeners, this.cancellationToken, this.buildIdentifier);
        }

        public void copyFrom(ConsumerOperationParameters operationParameters) {
            this.tasks = operationParameters.tasks;
            this.launchables = operationParameters.launchables;
            this.cancellationToken = operationParameters.cancellationToken;
            this.legacyProgressListeners.addAll(operationParameters.legacyProgressListeners);
            this.taskProgressListeners.addAll(operationParameters.taskProgressListeners);
            this.testProgressListeners.addAll(operationParameters.testProgressListeners);
            this.buildOperationProgressListeners.addAll(operationParameters.buildOperationProgressListeners);
            this.arguments = operationParameters.arguments;
            this.jvmArguments = operationParameters.jvmArguments;
            this.stdout = operationParameters.stdout;
            this.stderr = operationParameters.stderr;
            this.stdin = operationParameters.stdin;
            this.colorOutput = operationParameters.colorOutput;
            this.javaHome = operationParameters.javaHome;
            this.injectedPluginClasspath = operationParameters.injectedPluginClasspath;
        }
    }
}

