/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.buffer;

import java.io.File;
import java.io.IOException;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.ArrayBuffer;
import org.simpleframework.util.buffer.Buffer;
import org.simpleframework.util.buffer.BufferException;
import org.simpleframework.util.buffer.FileBuffer;
import org.simpleframework.util.buffer.FileManager;

public class FileAllocator
implements Allocator {
    private static final String PREFIX = "temp";
    private FileManager manager;
    private int limit;

    public FileAllocator() throws IOException {
        this(0x100000);
    }

    public FileAllocator(int limit) throws IOException {
        this(PREFIX, limit);
    }

    public FileAllocator(String prefix) throws IOException {
        this(prefix, 0x100000);
    }

    public FileAllocator(String prefix, int limit) throws IOException {
        this.manager = new FileManager(prefix);
        this.limit = limit;
    }

    public Buffer allocate() throws IOException {
        File file = this.manager.create();
        if (!file.exists()) {
            throw new BufferException("Could not create file %s", file);
        }
        return new FileBuffer(file);
    }

    public Buffer allocate(int size) throws IOException {
        if (size <= this.limit) {
            return new ArrayBuffer(size);
        }
        return this.allocate();
    }

    public void close() throws IOException {
        this.manager.close();
    }
}

