/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreUnavailableAnnouncer
implements Announcer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IgnoreUnavailableAnnouncer.class);
    private final Announcer announcer;

    public IgnoreUnavailableAnnouncer(Announcer announcer) {
        this.announcer = announcer;
    }

    public void send(String title, String message) {
        try {
            this.announcer.send(title, message);
        }
        catch (AnnouncerUnavailableException e) {
            LOGGER.debug("Discarding message [" + title + "][" + message + "] as announcer is not available: " + e.getMessage());
        }
    }
}

