/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.JavaVersion;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.launcher.daemon.configuration.DaemonParameters;

public class JvmVersionValidator {
    private final JvmVersionDetector versionDetector;

    public JvmVersionValidator(JvmVersionDetector versionDetector) {
        this.versionDetector = versionDetector;
    }

    public void validate(DaemonParameters parameters) {
        if (parameters.getEffectiveJvm().equals(Jvm.current())) {
            return;
        }
        JavaVersion javaVersion = this.versionDetector.getJavaVersion(parameters.getEffectiveJvm());
        if (!javaVersion.isJava6Compatible()) {
            throw UnsupportedJavaRuntimeException.configuredWithUnsupportedVersion("Gradle", JavaVersion.VERSION_1_6, javaVersion);
        }
    }
}

