/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.util.List;
import java.util.Properties;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.process.internal.JvmOptions;

public class BuildProcess
extends CurrentProcess {
    public BuildProcess() {
    }

    protected BuildProcess(JavaInfo jvm, JvmOptions effectiveJvmOptions) {
        super(jvm, effectiveJvmOptions);
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean javaHomeMatch = this.getJvm().equals(requiredBuildParameters.getEffectiveJvm());
        JvmOptions jvmOptions = new JvmOptions(new IdentityFileResolver());
        jvmOptions.systemProperties(this.getJvmOptions().getImmutableSystemProperties());
        List<String> currentImmutables = jvmOptions.getAllImmutableJvmArgs();
        List<String> requiredImmutables = requiredBuildParameters.getEffectiveSingleUseJvmArgs();
        requiredImmutables.removeAll(DaemonParameters.DEFAULT_JVM_ARGS);
        boolean noImmutableJvmArgsRequired = requiredImmutables.equals(currentImmutables);
        if (javaHomeMatch && noImmutableJvmArgsRequired) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }
}

