/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.JavaVersion;
import org.gradle.api.Nullable;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.configuration.DaemonJvmOptions;
import org.gradle.launcher.daemon.configuration.DaemonUsage;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonParameters {
    static final int DEFAULT_IDLE_TIMEOUT = 10800000;
    static final int DEFAULT_PERIODIC_CHECK_INTERVAL_MILLIS = 60000;
    public static final List<String> DEFAULT_JVM_ARGS = ImmutableList.of((Object)"-Xmx1024m", (Object)"-XX:MaxPermSize=256m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    public static final List<String> DEFAULT_JVM_9_ARGS = ImmutableList.of((Object)"-Xmx1024m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    public static final String INTERACTIVE_TOGGLE = "org.gradle.interactive";
    private final File gradleUserHomeDir;
    private File baseDir;
    private int idleTimeout = 10800000;
    private int periodicCheckInterval = 60000;
    private final DaemonJvmOptions jvmOptions = new DaemonJvmOptions(new IdentityFileResolver());
    private DaemonUsage daemonUsage = DaemonUsage.IMPLICITLY_DISABLED;
    private boolean hasJvmArgs;
    private boolean foreground;
    private boolean stop;
    private boolean interactive = System.console() != null || Boolean.getBoolean("org.gradle.interactive");
    private JavaInfo jvm = Jvm.current();

    public DaemonParameters(BuildLayoutParameters layout) {
        this(layout, Collections.emptyMap());
    }

    public DaemonParameters(BuildLayoutParameters layout, Map<String, String> extraSystemProperties) {
        this.jvmOptions.systemProperties(extraSystemProperties);
        this.baseDir = new File(layout.getGradleUserHomeDir(), "daemon");
        this.gradleUserHomeDir = layout.getGradleUserHomeDir();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public DaemonParameters setEnabled(boolean enabled) {
        this.daemonUsage = enabled ? DaemonUsage.EXPLICITLY_ENABLED : DaemonUsage.EXPLICITLY_DISABLED;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getPeriodicCheckInterval() {
        return this.periodicCheckInterval;
    }

    public void setPeriodicCheckInterval(int periodicCheckInterval) {
        this.periodicCheckInterval = periodicCheckInterval;
    }

    public List<String> getEffectiveJvmArgs() {
        return this.jvmOptions.getAllImmutableJvmArgs();
    }

    public List<String> getEffectiveSingleUseJvmArgs() {
        return this.jvmOptions.getAllSingleUseImmutableJvmArgs();
    }

    public JavaInfo getEffectiveJvm() {
        return this.jvm;
    }

    @Nullable
    public DaemonParameters setJvm(JavaInfo jvm) {
        this.jvm = jvm == null ? Jvm.current() : jvm;
        return this;
    }

    public void applyDefaultsFor(JavaVersion javaVersion) {
        if (this.hasJvmArgs) {
            return;
        }
        if (javaVersion.compareTo(JavaVersion.VERSION_1_9) >= 0) {
            this.jvmOptions.jvmArgs(DEFAULT_JVM_9_ARGS);
        } else {
            this.jvmOptions.jvmArgs(DEFAULT_JVM_ARGS);
        }
    }

    public Map<String, String> getSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getMutableSystemProperties());
        return systemProperties;
    }

    public Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getMutableSystemProperties());
        GUtil.addToMap(systemProperties, this.jvmOptions.getImmutableDaemonProperties());
        GUtil.addToMap(systemProperties, System.getProperties());
        return systemProperties;
    }

    public void setJvmArgs(Iterable<String> jvmArgs) {
        this.hasJvmArgs = true;
        this.jvmOptions.setAllJvmArgs(jvmArgs);
    }

    public void setDebug(boolean debug) {
        this.jvmOptions.setDebug(debug);
    }

    public DaemonParameters setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public boolean getDebug() {
        return this.jvmOptions.getDebug();
    }

    public DaemonUsage getDaemonUsage() {
        return this.daemonUsage;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

