/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.remote.Address;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.context.DaemonContext;

public class DaemonInfo
implements Serializable,
DaemonConnectDetails {
    private final Address address;
    private final DaemonContext context;
    private final byte[] token;
    private final TimeProvider timeProvider;
    private boolean idle;
    private long lastBusy;

    public DaemonInfo(Address address, DaemonContext context, byte[] token, boolean idle) {
        this(address, context, token, idle, new TrueTimeProvider());
    }

    @VisibleForTesting
    DaemonInfo(Address address, DaemonContext context, byte[] token, boolean idle, TimeProvider busyClock) {
        this.address = (Address)Preconditions.checkNotNull((Object)address);
        this.context = (DaemonContext)Preconditions.checkNotNull((Object)context);
        this.token = (byte[])Preconditions.checkNotNull((Object)token);
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)busyClock);
        this.lastBusy = -1L;
        this.setIdle(idle);
    }

    public DaemonInfo setIdle(boolean idle) {
        this.idle = idle;
        if (!idle) {
            this.lastBusy = this.timeProvider.getCurrentTime();
        }
        return this;
    }

    public String getUid() {
        return this.context.getUid();
    }

    public Long getPid() {
        return this.context.getPid();
    }

    public Address getAddress() {
        return this.address;
    }

    public DaemonContext getContext() {
        return this.context;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public byte[] getToken() {
        return this.token;
    }

    public Date getLastBusy() {
        return new Date(this.lastBusy);
    }

    public String toString() {
        return String.format("DaemonInfo{pid=%s, address=%s, idle=%s, lastBusy=%s, context=%s}", this.context.getPid(), this.address, this.idle, this.lastBusy, this.context);
    }
}

